/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObjectImpl;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class DirectoryTreeNode
implements MutableTreeNode {
    private DirectoryTreeObject directoryTreeObject;
    private ArrayList<DirectoryTreeNode> childNodes = new ArrayList();
    private DirectoryTreeNode parent;
    private boolean staleChildCache = true;
    private DirectoryTree tree;
    private DefaultTreeModel treeModel;
    private Messages messages;
    private OperationManager manager;
    private InitialLdapContext iCtx;
    private Workbench workbench;
    private String presentationName = null;

    DirectoryTreeNode(DirectoryTree tree, Workbench workbench, Messages messages, OperationManager manager, DefaultTreeModel treeModel, InitialLdapContext iCtx, DirectoryTreeNode parent, String rdn) throws NamingException {
        String dn;
        this.parent = parent;
        this.treeModel = treeModel;
        this.messages = messages;
        this.manager = manager;
        this.iCtx = iCtx;
        this.tree = tree;
        this.workbench = workbench;
        if (rdn.indexOf(47) != -1) {
            rdn = rdn.replaceAll("\"", "").replaceAll("/", "\\/");
        }
        if (parent != null && parent.getDn() != null) {
            Name thisName = ((Name)parent.getDn().clone()).add(rdn);
            dn = thisName.toString();
        } else {
            dn = rdn;
        }
        Name nodeName = iCtx.getNameParser("").parse(dn);
        this.directoryTreeObject = new DirectoryTreeObjectImpl(nodeName, tree);
    }

    DirectoryTreeObject getObject() {
        return this.directoryTreeObject;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.staleChildCache) {
            this.listChildren();
        }
        return this.childNodes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        if (this.staleChildCache) {
            this.listChildren();
        }
        return this.childNodes.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.childNodes.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        if (this.staleChildCache) {
            return false;
        }
        return this.childNodes.size() == 0;
    }

    public Enumeration children() {
        if (this.staleChildCache) {
            this.listChildren();
        }
        return new IteratorEnumerator(this.childNodes.iterator());
    }

    void clearChildCache() {
        this.staleChildCache = true;
        this.childNodes.clear();
    }

    private synchronized void listChildren() {
        this.manager.runOperation(new Operation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws NamingException {
                SearchControls ctrls = new SearchControls();
                ctrls.setSearchScope(1);
                ctrls.setReturningAttributes(new String[0]);
                ctrls.setReturningObjFlag(false);
                NamingEnumeration<SearchResult> resultSet = null;
                try {
                    Name searchRoot = DirectoryTreeNode.this.directoryTreeObject.getDistinguishedName();
                    ArrayList<String> childNames = new ArrayList<String>();
                    try {
                        resultSet = DirectoryTreeNode.this.iCtx.search(searchRoot, "objectClass=*", ctrls);
                        while (resultSet.hasMore()) {
                            SearchResult result = resultSet.next();
                            childNames.add(result.getName());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    DirectoryTreeNode.this.result(childNames);
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
        });
    }

    public synchronized void result(ArrayList<String> childNames) throws NamingException {
        this.childNodes.clear();
        for (int i = 0; i < childNames.size(); ++i) {
            this.childNodes.add(new DirectoryTreeNode(this.tree, this.workbench, this.messages, this.manager, this.treeModel, this.iCtx, this, childNames.get(i)));
        }
        this.staleChildCache = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DirectoryTreeNode.this.treeModel.nodeStructureChanged(DirectoryTreeNode.this);
            }
        });
        this.notifyAll();
    }

    Name getDn() {
        return this.directoryTreeObject.getDistinguishedName();
    }

    Name getRdn() {
        Name dn = this.directoryTreeObject.getDistinguishedName();
        Name rdn = dn.getSuffix(dn.size() - 1);
        return rdn;
    }

    synchronized DirectoryTreeNode getChildWithRDN(String rdn) {
        if (this.staleChildCache) {
            this.listChildren();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        DirectoryTreeNode result = null;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            DirectoryTreeNode child = this.childNodes.get(i);
            if (!child.getRdn().toString().equals(rdn)) continue;
            result = child;
            break;
        }
        return result;
    }

    public String toString() {
        if (this.presentationName == null) {
            if (this.parent == null) {
                try {
                    this.presentationName = this.iCtx.getNameInNamespace();
                }
                catch (NamingException e) {
                    this.presentationName = this.getDn().toString();
                }
                if (this.presentationName.length() < 1) {
                    this.presentationName = "[Root]";
                }
            } else {
                return this.getRdn().toString();
            }
        }
        return this.presentationName;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        if (!(child instanceof DirectoryTreeNode)) {
            throw new IllegalArgumentException("Will only add DirectoryTreeNode to the tree");
        }
        this.childNodes.add(index, (DirectoryTreeNode)child);
    }

    @Override
    public void remove(int index) {
        this.childNodes.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.childNodes.remove(node);
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        if (!(newParent instanceof DirectoryTreeNode)) {
            throw new IllegalArgumentException("Will only parent to LdapTreeNode");
        }
        throw new IllegalStateException("Not implemented yet");
    }

    @Override
    public void setUserObject(Object object) {
        throw new IllegalArgumentException("LdapTreeNodes have no user object");
    }

    public class IteratorEnumerator
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnumerator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

