/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.directory.attributes.AllAttributesComponent;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeSelectionListener;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.ops4j.gaderian.Messages;

public class DirectoryTreeAndAttributesComponent
extends JComponent
implements DirectoryTreeSelectionListener,
WorkbenchFrameListener {
    private DirectoryTree treeComponent;
    private AllAttributesComponent attributesComponent;
    private OperationManager operationManager;
    private Workbench workbench;
    private Messages messages;
    private JSplitPane splitter;
    private Preferences preferences;
    private ConnectionGUID guid;

    public DirectoryTreeAndAttributesComponent(DirectoryTree treeComponent, AllAttributesComponent attributesComponent, OperationManager operationManager, Workbench workbench, Messages messages, Preferences preferences, ConnectionGUID guid) {
        this.treeComponent = treeComponent;
        this.attributesComponent = attributesComponent;
        this.operationManager = operationManager;
        this.workbench = workbench;
        this.messages = messages;
        this.preferences = preferences;
        this.guid = guid;
        this.buildGUI();
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.splitter = new JSplitPane(1, this.treeComponent, this.attributesComponent);
        this.add((Component)this.splitter, "Center");
        this.treeComponent.addDirectoryTreeSelectionListener(this);
    }

    @Override
    public void selectionChanged(DirectoryTree tree, final InitialLdapContext iCtx) {
        try {
            final DirectoryTreeObject node = tree.getSelectedNode();
            if (node != null) {
                this.operationManager.runOperation(new Operation(){

                    @Override
                    public void execute() throws NamingException {
                        Attributes attributes = iCtx.getAttributes(node.getDistinguishedName());
                        DirectoryTreeAndAttributesComponent.this.attributesComponent.show(node.getDistinguishedName(), attributes);
                    }
                });
            }
        }
        catch (NamingException e) {
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("error.treeComponent.getselectednode"), (Exception)e);
        }
    }

    public void setDividerLocation() {
        if (this.splitter != null) {
            try {
                Integer location = this.preferences.getInteger("DirectoryTreeAndAttributesComponent." + this.guid.toString());
                if (location != null) {
                    this.splitter.setDividerLocation(location);
                } else {
                    this.splitter.setDividerLocation(0.5);
                }
            }
            catch (Exception e) {
                this.splitter.setDividerLocation(0.5);
            }
        }
    }

    public void frameWillDispose(WorkbenchFrame frame) {
        Integer location = new Integer(this.splitter.getDividerLocation());
        try {
            this.preferences.setInteger("DirectoryTreeAndAttributesComponent." + this.guid.toString(), location);
        }
        catch (BackendException backendException) {
            // empty catch block
        }
    }

    public void frameClosed(WorkbenchFrame frame) {
    }
}

