/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Icon;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class DeleteItem
implements DirectoryTreePopUpItem {
    private Messages messages;
    private Workbench workbench;
    private DirectoryEventListenerRegistry eventRegistry;

    public DeleteItem(Messages messages, Workbench workbench, DirectoryEventListenerRegistry eventRegistry) {
        this.messages = messages;
        this.workbench = workbench;
        this.eventRegistry = eventRegistry;
    }

    @Override
    public void activate(DirectoryTree tree) {
        DirectoryTreeObject[] selectedNodes = null;
        try {
            selectedNodes = tree.getSelectedNodes();
        }
        catch (NamingException e) {
            selectedNodes = null;
        }
        if (selectedNodes != null) {
            for (int i = 0; i < selectedNodes.length; ++i) {
                InitialLdapContext iCtx = tree.getConnection();
                Name nodeToDelete = selectedNodes[i].getDistinguishedName();
                Name parent = nodeToDelete.getPrefix(nodeToDelete.size() - 1);
                try {
                    this.workbench.setStatusbarMessage(this.messages.format("tree.popup.delete.node", (Object)nodeToDelete.toString()));
                    iCtx.destroySubcontext(nodeToDelete);
                    this.eventRegistry.fireStructureChanged(tree.getConnectionInformation().getGUID(), parent);
                    continue;
                }
                catch (NamingException e1) {
                    this.workbench.getErrorReporter().reportError(this.messages.getMessage("error.tree.delete"), (Exception)e1);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.messages.getMessage("tree.popup.delete");
    }

    @Override
    public String getToolTip() {
        return this.messages.getMessage("tree.popup.delete.tooltip");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Integer getMnemonic() {
        return new Integer(127);
    }

    @Override
    public Integer getAcceleratorKey() {
        return new Integer(127);
    }

    @Override
    public Integer getAcceleratorKeyMask() {
        return null;
    }
}

