/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.NamingException;
import javax.swing.Icon;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboard;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class CutItem
implements DirectoryTreePopUpItem {
    private Messages messages;
    private DirectoryClipboard clipboard;
    private Workbench workbench;

    public CutItem(Messages messages, DirectoryClipboard clipboard, Workbench workbench) {
        this.messages = messages;
        this.clipboard = clipboard;
        this.workbench = workbench;
    }

    @Override
    public void activate(DirectoryTree tree) {
        try {
            DirectoryTreeObject[] selectedNames = tree.getSelectedNodes();
            if (selectedNames != null) {
                for (int i = 0; i < selectedNames.length; ++i) {
                    this.clipboard.addCut(selectedNames[i]);
                }
            }
        }
        catch (NamingException e) {
            this.workbench.getErrorReporter().reportError((Exception)e);
        }
    }

    @Override
    public String getName() {
        return this.messages.getMessage("tree.popup.cut");
    }

    @Override
    public String getToolTip() {
        return this.messages.getMessage("tree.popup.cut");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Integer getMnemonic() {
        return new Integer(85);
    }

    @Override
    public Integer getAcceleratorKey() {
        return new Integer(88);
    }

    @Override
    public Integer getAcceleratorKeyMask() {
        return new Integer(128);
    }
}

