/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.NamingException;
import javax.swing.Icon;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboard;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class CopyItem
implements DirectoryTreePopUpItem {
    private Messages messages;
    private DirectoryClipboard clipboard;
    private Workbench workbench;

    public CopyItem(Messages messages, DirectoryClipboard clipboard, Workbench workbench) {
        this.messages = messages;
        this.clipboard = clipboard;
        this.workbench = workbench;
    }

    @Override
    public void activate(DirectoryTree tree) {
        try {
            DirectoryTreeObject[] selectedNames = tree.getSelectedNodes();
            if (selectedNames != null) {
                for (int i = 0; i < selectedNames.length; ++i) {
                    this.clipboard.addCopy(selectedNames[i]);
                }
            }
        }
        catch (NamingException e) {
            this.workbench.getErrorReporter().reportError((Exception)e);
        }
    }

    @Override
    public String getName() {
        return this.messages.getMessage("tree.popup.copy");
    }

    @Override
    public String getToolTip() {
        return this.messages.getMessage("tree.popup.copy.tooltip");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Integer getMnemonic() {
        return new Integer(67);
    }

    @Override
    public Integer getAcceleratorKey() {
        return new Integer(67);
    }

    @Override
    public Integer getAcceleratorKeyMask() {
        return new Integer(128);
    }
}

