/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.attributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nu.zoom.ldap.eon.connection.ConnectionInformation;
import nu.zoom.ldap.eon.directory.attributes.AttributeEditor;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.action.WorkbenchAction;
import org.ops4j.gaderian.Messages;

public class StringEditor
implements AttributeEditor {
    private JDialog dlg;
    private String attributeID;
    private JTable valueTable;
    private Workbench workbench;
    private Messages messages;
    private OperationManager operationManager;
    private InitialLdapContext iCtx;
    private Name name;
    private DirectoryEventListenerRegistry eventListeners;
    private ConnectionInformation connectionInformation;

    public StringEditor(Workbench workbench, Messages messages, OperationManager operationManager, DirectoryEventListenerRegistry eventListeners) {
        this.messages = messages;
        this.workbench = workbench;
        this.operationManager = operationManager;
        this.eventListeners = eventListeners;
    }

    @Override
    public void edit(ConnectionInformation connectionInformation, InitialLdapContext iCtx, Name name, Attribute attribute) {
        this.attributeID = attribute.getID();
        this.iCtx = iCtx;
        this.name = name;
        this.connectionInformation = connectionInformation;
        Vector values = new Vector();
        try {
            NamingEnumeration<?> valueEnum = attribute.getAll();
            while (valueEnum.hasMore()) {
                Vector rowData = new Vector();
                rowData.add(valueEnum.next());
                values.add(rowData);
            }
            JDialog dlg = this.buildGUI(values);
            dlg.setVisible(true);
        }
        catch (NamingException e) {
            this.workbench.getErrorReporter().reportError((Exception)e);
        }
    }

    @Override
    public void create(ConnectionInformation connectionInformation, InitialLdapContext iCtx, Name name, String newAttributeID) {
        this.attributeID = newAttributeID;
        this.iCtx = iCtx;
        this.name = name;
        this.connectionInformation = connectionInformation;
        JDialog dlg = this.buildGUI(null);
        dlg.setVisible(true);
    }

    private JDialog buildGUI(Vector editValues) {
        this.dlg = new JDialog(this.workbench.getDialogOwner(), this.messages.format("attributes.stringeditor.title", (Object)this.attributeID), true);
        this.dlg.setLocationRelativeTo(this.workbench.getDialogOwner());
        this.dlg.setDefaultCloseOperation(2);
        Vector<String> header = new Vector<String>();
        header.add(this.messages.getMessage("attributes.table.header.value"));
        if (editValues == null) {
            editValues = new Vector();
        }
        this.valueTable = new JTable(editValues, header);
        this.valueTable.setEnabled(true);
        this.valueTable.setShowGrid(true);
        JScrollPane tableScroller = new JScrollPane(this.valueTable);
        JButton okButton = new JButton(this.messages.getMessage("attributes.stringeditor.action.ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor.this.saveAttributeReplaceValues();
                StringEditor.this.dlg.dispose();
            }
        });
        JButton cancelButton = new JButton(this.messages.getMessage("attributes.stringeditor.action.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor.this.workbench.setStatusbarMessage(StringEditor.this.messages.getMessage("attributes.stringeditor.action.cancelled"));
                StringEditor.this.dlg.dispose();
            }
        });
        AddValueAction addAction = new AddValueAction();
        JButton addValueButton = new JButton((Action)((Object)addAction));
        DeleteValueAction deleteAction = new DeleteValueAction();
        JButton deleteValueButton = new JButton((Action)((Object)deleteAction));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(addValueButton);
        buttonPanel.add(deleteValueButton);
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.dlg.getContentPane().setLayout(new BorderLayout());
        this.dlg.getContentPane().add((Component)tableScroller, "Center");
        this.dlg.getContentPane().add((Component)buttonPanel, "South");
        this.dlg.pack();
        return this.dlg;
    }

    private void saveAttributeReplaceValues() {
        Vector<Vector> rows;
        TableModel model = this.valueTable.getModel();
        if (model instanceof DefaultTableModel && (rows = ((DefaultTableModel)model).getDataVector()) != null) {
            final BasicAttribute attribute = new BasicAttribute(this.attributeID);
            for (Vector columns : rows) {
                if (columns == null || columns.size() <= 0) continue;
                String value = (String)columns.get(0);
                attribute.add(value);
            }
            this.operationManager.runOperation(new Operation(){

                @Override
                public void execute() throws NamingException {
                    ModificationItem moditem = new ModificationItem(2, attribute);
                    StringEditor.this.iCtx.modifyAttributes(StringEditor.this.name, new ModificationItem[]{moditem});
                    StringEditor.this.eventListeners.fireAttributesChanged(StringEditor.this.connectionInformation.getGUID(), StringEditor.this.name);
                }
            });
        }
    }

    class DeleteValueAction
    extends WorkbenchAction {
        DeleteValueAction() {
            this.setName(StringEditor.this.messages.getMessage("attributes.stringeditor.action.delete"));
            this.setAcceleratorKey(65, 128);
        }

        public void actionPerformed(ActionEvent e) {
            TableModel model;
            int selectedRow = StringEditor.this.valueTable.getSelectedRow();
            if (selectedRow > -1 && (model = StringEditor.this.valueTable.getModel()) instanceof DefaultTableModel) {
                ((DefaultTableModel)model).removeRow(selectedRow);
            }
        }
    }

    class AddValueAction
    extends WorkbenchAction {
        AddValueAction() {
            this.setName(StringEditor.this.messages.getMessage("attributes.stringeditor.action.add"));
            this.setAcceleratorKey(65, 128);
        }

        public void actionPerformed(ActionEvent e) {
            TableModel model;
            String newValue = JOptionPane.showInputDialog(StringEditor.this.dlg, (Object)StringEditor.this.messages.getMessage("attributes.stringeditor.action.add"));
            if (newValue != null && newValue.length() > 0 && (model = StringEditor.this.valueTable.getModel()) instanceof DefaultTableModel) {
                Vector<String> row = new Vector<String>();
                row.add(newValue);
                ((DefaultTableModel)model).addRow(row);
            }
        }
    }
}

