/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.desktop;

import java.awt.EventQueue;
import java.util.List;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JComponent;
import nu.zoom.ldap.eon.connection.ConnectionInformation;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.directory.attributes.AllAttributesComponent;
import nu.zoom.ldap.eon.directory.attributes.AttributeEditorFactory;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeAndAttributesComponent;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.ops4j.gaderian.Messages;

public class ComponentFactoryImpl
implements ComponentFactory {
    private Workbench workbench;
    private Messages messages;
    private OperationManager operationManager;
    private Preferences preferences;
    private AttributeEditorFactory attributeEditorFactory;
    private DirectoryEventListenerRegistry eventRegistry;
    private List<DirectoryTreePopUpItem> popupItems;

    public ComponentFactoryImpl(Workbench workbench, Messages messages, OperationManager operationManager, Preferences preferences, AttributeEditorFactory attributeEditorFactory, DirectoryEventListenerRegistry eventRegistry, List<DirectoryTreePopUpItem> popupItems) {
        this.workbench = workbench;
        this.messages = messages;
        this.operationManager = operationManager;
        this.preferences = preferences;
        this.attributeEditorFactory = attributeEditorFactory;
        this.eventRegistry = eventRegistry;
        this.popupItems = popupItems;
    }

    @Override
    public void showNewConnection(final InitialLdapContext iCtx, final ConnectionInformation connectionInformation) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DirectoryTree tree = new DirectoryTree(ComponentFactoryImpl.this.operationManager, ComponentFactoryImpl.this.workbench, ComponentFactoryImpl.this.messages, iCtx, connectionInformation, ComponentFactoryImpl.this.popupItems);
                ComponentFactoryImpl.this.eventRegistry.addEventListener(connectionInformation.getGUID(), tree);
                AllAttributesComponent attrs = new AllAttributesComponent(ComponentFactoryImpl.this.workbench, ComponentFactoryImpl.this.messages, ComponentFactoryImpl.this.attributeEditorFactory, iCtx, connectionInformation);
                ComponentFactoryImpl.this.eventRegistry.addEventListener(connectionInformation.getGUID(), attrs);
                DirectoryTreeAndAttributesComponent comp = new DirectoryTreeAndAttributesComponent(tree, attrs, ComponentFactoryImpl.this.operationManager, ComponentFactoryImpl.this.workbench, ComponentFactoryImpl.this.messages, ComponentFactoryImpl.this.preferences, connectionInformation.getGUID());
                WorkbenchFrame frame = ComponentFactoryImpl.this.workbench.createWorkbenchFrame("nu.zoom.eon2.connection.frame." + connectionInformation.getGUID(), (JComponent)comp, true, true);
                frame.setTitle(connectionInformation.getDescription());
                frame.addFrameListener((WorkbenchFrameListener)comp);
                frame.setVisible(true);
                comp.setDividerLocation();
            }
        });
    }

    @Override
    public JComponent getAllAttributesComponent(InitialLdapContext iCtx, ConnectionInformation connectionInformation) {
        return new AllAttributesComponent(this.workbench, this.messages, this.attributeEditorFactory, iCtx, connectionInformation);
    }
}

