/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection.password;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.swing.desktop.common.BackendException;

public class AnonymousConnection
implements Connection,
Serializable {
    static final long serialVersionUID = 1746373875944572437L;
    private ConnectionGUID id = ConnectionGUID.getInstance();
    private String host = null;
    private int port = -1;
    private String description;
    private String rootContext = null;

    @Override
    public ConnectionGUID getGUID() {
        return this.id;
    }

    @Override
    public InitialLdapContext getConnection() throws BackendException {
        Hashtable env = new Hashtable();
        this.setupEnvironment(env);
        try {
            InitialLdapContext iCtx = new InitialLdapContext(env, null);
            return iCtx;
        }
        catch (NamingException e) {
            throw new BackendException((Throwable)e);
        }
    }

    protected void setupEnvironment(Hashtable env) {
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        StringBuffer ldapURL = new StringBuffer();
        ldapURL.append("ldap://");
        ldapURL.append(this.host);
        ldapURL.append(":");
        ldapURL.append(this.port);
        if (this.getRootContext() != null) {
            ldapURL.append("/");
            ldapURL.append(this.rootContext);
        }
        env.put("java.naming.provider.url", ldapURL.toString());
        env.put("java.naming.referral", "follow");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGUID(ConnectionGUID id) {
        this.id = id;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(String rootContext) {
        this.rootContext = rootContext;
    }
}

