/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.EventQueue;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import nu.zoom.ldap.eon.connection.ConnectAction;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionFactory;
import nu.zoom.ldap.eon.connection.ConnectionFactoryListener;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.connection.CreateConnectionAction;
import nu.zoom.ldap.eon.connection.DeleteConnectionAction;
import nu.zoom.ldap.eon.connection.EditConnectionAction;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import org.ops4j.gaderian.Messages;

public class ConnectionMenuChangeHandler
implements ConnectionFactoryListener {
    private JMenu connectionFactoryMenu = null;
    private Workbench workbench;
    private Messages messages;
    private ConnectionFactory connectionFactory;
    private ComponentFactory componentFactory;
    private OperationManager operationManager;

    public ConnectionMenuChangeHandler(Workbench workbench, Messages messages, ComponentFactory componentFactory, OperationManager operationManager, ConnectionFactory connectionFactory) {
        this.workbench = workbench;
        this.messages = messages;
        this.connectionFactory = connectionFactory;
        this.componentFactory = componentFactory;
        this.operationManager = operationManager;
        connectionFactory.addConnectionFactoryListener(this);
        this.rebuildMenu();
    }

    @Override
    public synchronized void createdConnection(Connection connection) {
        this.rebuildMenu();
    }

    @Override
    public synchronized void removedConnection(ConnectionGUID connectionGUID) {
        this.rebuildMenu();
    }

    @Override
    public synchronized void connectionDataChanged(Connection connection) {
        this.rebuildMenu();
    }

    synchronized JMenu getMenu() {
        return this.connectionFactoryMenu;
    }

    private synchronized void rebuildMenu() {
        if (EventQueue.isDispatchThread()) {
            this.rebuildMenuOnEventQueue();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionMenuChangeHandler.this.rebuildMenuOnEventQueue();
                }
            });
        }
    }

    private synchronized void rebuildMenuOnEventQueue() {
        if (this.connectionFactoryMenu == null) {
            this.connectionFactoryMenu = new JMenu(this.connectionFactory.getName());
            this.connectionFactoryMenu.setToolTipText(this.connectionFactory.getDescription());
            ImageIcon connectionIcon = this.connectionFactory.getIcon();
            if (connectionIcon != null) {
                this.connectionFactoryMenu.setIcon(connectionIcon);
            }
        } else {
            this.connectionFactoryMenu.removeAll();
        }
        try {
            Connection[] connections = this.connectionFactory.listConnections();
            if (connections != null) {
                for (int j = 0; j < connections.length; ++j) {
                    JMenu connectionMenu = new JMenu(connections[j].getDescription());
                    connectionMenu.add((Action)((Object)new ConnectAction(this.workbench, this.messages, connections[j], this.componentFactory, this.operationManager)));
                    connectionMenu.add((Action)((Object)new EditConnectionAction(this.workbench, this.messages, this.connectionFactory, connections[j])));
                    connectionMenu.add((Action)((Object)new DeleteConnectionAction(this.messages, this.workbench, this.connectionFactory, connections[j])));
                    this.connectionFactoryMenu.add(connectionMenu);
                }
            }
        }
        catch (BackendException exc) {
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("connection.error.listconnection"), (Exception)((Object)exc));
        }
        this.connectionFactoryMenu.addSeparator();
        this.connectionFactoryMenu.add((Action)((Object)new CreateConnectionAction(this.workbench, this.messages, this.connectionFactory, this.connectionFactory.getIcon())));
    }
}

