/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection;

import java.awt.EventQueue;
import javax.naming.ldap.InitialLdapContext;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import org.ops4j.gaderian.Messages;

public class ConnectOperation
implements Operation {
    private Workbench workbench;
    private Messages messages;
    private Connection connection;
    private ComponentFactory componentFactory;

    public ConnectOperation(Workbench workbench, Messages messages, Connection connection, ComponentFactory componentFactory) {
        this.workbench = workbench;
        this.messages = messages;
        this.connection = connection;
        this.componentFactory = componentFactory;
    }

    @Override
    public void execute() {
        try {
            this.workbench.startWorkIndicator();
            this.workbench.setStatusbarMessage(this.messages.format("connection.connecting", (Object)this.connection.getDescription()));
            final InitialLdapContext iCtx = this.connection.getConnection();
            if (iCtx != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectOperation.this.workbench.stopWorkIndicator();
                        ConnectOperation.this.componentFactory.showNewConnection(iCtx, ConnectOperation.this.connection);
                    }
                });
            }
        }
        catch (BackendException e) {
            this.workbench.stopWorkIndicator();
            this.workbench.getErrorReporter().reportError(this.messages.format("connection.connect.error", (Object)this.connection.getDescription()), (Exception)((Object)e));
        }
    }
}

