/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionEditor;
import nu.zoom.ldap.eon.connection.ConnectionFactory;
import nu.zoom.ldap.eon.connection.ConnectionFactoryListener;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.swing.desktop.common.BackendException;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    private ArrayList<ConnectionFactoryListener> listeners = new ArrayList();

    @Override
    public synchronized void addConnectionFactoryListener(ConnectionFactoryListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeConnectionFactoryListener(ConnectionFactoryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void removeConnection(Connection connection) throws BackendException {
        if (connection != null) {
            ConnectionGUID id = connection.getGUID();
            this.delegateRemoveConnection(connection);
            this.fireConnectionRemoved(id);
        }
    }

    public synchronized void addConnection(Connection connection) throws BackendException {
        this.delegateAddConnection(connection);
        this.fireConnectionAdded(connection);
    }

    public synchronized void connectionChanged(Connection connection) throws BackendException {
        this.delegateConnectionChanged(connection);
        this.fireConnectionChanged(connection);
    }

    protected abstract void delegateAddConnection(Connection var1) throws BackendException;

    protected abstract void delegateRemoveConnection(Connection var1) throws BackendException;

    protected abstract void delegateConnectionChanged(Connection var1) throws BackendException;

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getName();

    @Override
    public abstract ImageIcon getIcon();

    @Override
    public abstract ConnectionEditor getEditor();

    protected synchronized void fireConnectionAdded(Connection connection) {
        for (ConnectionFactoryListener listener : this.listeners) {
            listener.createdConnection(connection);
        }
    }

    protected synchronized void fireConnectionChanged(Connection connection) {
        for (ConnectionFactoryListener listener : this.listeners) {
            listener.connectionDataChanged(connection);
        }
    }

    protected synchronized void fireConnectionRemoved(ConnectionGUID connectionID) {
        for (ConnectionFactoryListener listener : this.listeners) {
            listener.removedConnection(connectionID);
        }
    }
}

