/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.clipboard.impl;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboardItem;
import nu.zoom.ldap.eon.clipboard.impl.ClipboardAction;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.util.UniqueIDGenerator;
import org.ops4j.gaderian.Messages;

public class DirectoryObjectCopyClipboardItem
implements DirectoryClipboardItem,
ClipboardAction {
    private static UniqueIDGenerator idGenerator = new UniqueIDGenerator();
    private String id;
    private String description;
    private Messages messages;
    private Workbench workbench;
    private DirectoryTreeObject sourceObject;
    private DirectoryEventListenerRegistry eventRegistry;

    public DirectoryObjectCopyClipboardItem(DirectoryTreeObject sourceObject, Messages messages, Workbench workbench, DirectoryEventListenerRegistry eventRegistry) {
        this.messages = messages;
        this.workbench = workbench;
        this.sourceObject = sourceObject;
        this.eventRegistry = eventRegistry;
        this.id = idGenerator.getID();
        this.description = messages.format("clipboard.object.copy", (Object)sourceObject.getConnectionInformation().getDescription(), (Object)sourceObject.getDistinguishedName().toString());
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void execute(DirectoryTreeObject target) throws BackendException {
        try {
            this.workbench.startWorkIndicator();
            Attributes attributes = this.sourceObject.getConnection().getAttributes(this.sourceObject.getDistinguishedName());
            Name sourceName = this.sourceObject.getDistinguishedName();
            Name sourceRDN = sourceName.getSuffix(sourceName.size() - 1);
            Name newName = ((Name)target.getDistinguishedName().clone()).addAll(sourceRDN);
            this.workbench.setStatusbarMessage(this.messages.format("clipboard.object.cut", (Object)this.sourceObject.getDistinguishedName(), (Object)newName.toString()));
            target.getConnection().createSubcontext(newName, attributes);
            this.eventRegistry.fireStructureChanged(target.getTree().getConnectionInformation().getGUID(), newName);
            this.workbench.stopWorkIndicator();
        }
        catch (NamingException e) {
            this.workbench.stopWorkIndicator();
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("error.tree.copy"), (Exception)e);
        }
    }
}

