/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.about;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import nu.zoom.ldap.eon.desktop.BasicPlugIn;
import nu.zoom.ldap.eon.util.MessagesUtil;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.ToggleFrameAction;
import nu.zoom.swing.desktop.plugin.browser.Browser;
import nu.zoom.swing.layout.VerticalPanel;
import org.ops4j.gaderian.Messages;

public class About
extends BasicPlugIn {
    private Browser browser;

    public About(Workbench workbench, Messages messages, Browser browser) {
        super(workbench, messages);
        this.browser = browser;
    }

    @Override
    public void start() {
        super.start();
        JMenuItem aboutMenuItem = new JMenuItem();
        AboutAction aboutAction = new AboutAction(this.messages, aboutMenuItem);
        aboutAction.setNameFromMessages("about.menuitem");
        this.workbench.getMenuBar().addToHelpMenu(aboutMenuItem);
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                About.this.browser.open(e.getURL());
            }
        }
    }

    public class AboutAction
    extends ToggleFrameAction<JMenuItem> {
        public AboutAction(Messages messages, JMenuItem button) {
            super(messages, (AbstractButton)button);
            this.setIconFromMessages("about.menuitem.icon");
        }

        protected WorkbenchFrame createFrame() {
            About.this.workbench.setStatusbarMessage(this.messages.getMessage("about.copyright"));
            VerticalPanel copyPanel = new VerticalPanel();
            copyPanel.addRow((JComponent)new JLabel(this.messages.getMessage("about.copyright")));
            copyPanel.addRow((JComponent)new JLabel(this.messages.getMessage("about.license")));
            VerticalPanel mainPanel = new VerticalPanel();
            mainPanel.addRow((JComponent)new JLabel(MessagesUtil.getIconFromMessages(this.messages, "about.banner")), (JComponent)copyPanel);
            try {
                InputStream ins = About.class.getResourceAsStream(this.messages.getMessage("about.html"));
                InputStreamReader inr = new InputStreamReader(ins, "ISO-8859-1");
                StringBuilder aboutBuffer = new StringBuilder();
                char[] readBuffer = new char[1024];
                int numread = inr.read(readBuffer);
                while (numread > 0) {
                    aboutBuffer.append(readBuffer, 0, numread);
                    numread = inr.read(readBuffer);
                }
                String text = aboutBuffer.toString();
                JEditorPane aboutPane = new JEditorPane("text/html", text);
                aboutPane.setEditable(false);
                aboutPane.addHyperlinkListener(new Hyperactive());
                mainPanel.addRow((JComponent)aboutPane);
            }
            catch (IOException e) {
                mainPanel.addRow((JComponent)new JTextArea(e.toString()));
            }
            mainPanel.validate();
            WorkbenchFrame frame = About.this.workbench.createWorkbenchFrame(((Object)((Object)this)).getClass().getName(), (JComponent)mainPanel, true, true);
            frame.setTitle(this.messages.getMessage("about.menuitem"));
            frame.setFrameIcon(MessagesUtil.getIconFromMessages(this.messages, "about.menuitem.icon"));
            return frame;
        }
    }
}

