/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.component.stringmenu.impl;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import nu.zoom.swing.action.AbstractTypedAction;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.component.stringmenu.StringMenu;
import nu.zoom.swing.desktop.component.stringmenu.StringMenuItem;
import nu.zoom.swing.desktop.component.stringmenu.StringMenuListener;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringMenuImpl<T extends Comparable<T> & Serializable>
implements StringMenu<T>,
WorkbenchListener {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HashMap<StringMenuItem<T>, JMenuItem> itemStringToJMenuItem = new HashMap();
    private final ArrayList<StringMenuListener<T>> listeners = new ArrayList();
    private final ArrayList<StringMenuItem<T>> itemStrings = new ArrayList();
    private JMenu menu = null;
    private final Preferences preferences;
    private final String preferencesKey;

    StringMenuImpl(Preferences preferences, Workbench workbench, String preferencesKey) {
        this.preferences = preferences;
        this.preferencesKey = preferencesKey;
        this.log.trace((Object)"New String menu is registering as workbench listener");
        workbench.addWorkBenchListener((WorkbenchListener)this);
    }

    @Override
    public synchronized void addListener(StringMenuListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener may not be null");
        }
        this.log.trace((Object)("Registering a string menu listener: " + listener));
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(StringMenuListener<T> listener) {
        this.log.trace((Object)("Removing a string menu listener: " + listener));
        this.listeners.remove(listener);
    }

    @Override
    public synchronized JMenu getJMenu(String menuName, Icon icon, String clearName, String clearTooltip) {
        if (this.menu == null) {
            this.createJMenu(menuName, icon, clearName, clearTooltip);
            this.restoreMenu();
        }
        return this.menu;
    }

    @Override
    public synchronized void addItem(StringMenuItem<T> menuItem) {
        if (menuItem == null) {
            this.log.fatal((Object)"Item may not be null");
            throw new IllegalArgumentException("Item may not be null");
        }
        if (!EventQueue.isDispatchThread()) {
            this.log.fatal((Object)"Must be called on the EventQueue dispatch thread");
            throw new IllegalStateException("Must be called on the EventQueue dispatch thread");
        }
        if (!this.itemStringToJMenuItem.containsKey(menuItem)) {
            this.log.trace((Object)"Adding item to menu");
            this.addItemInternal(menuItem);
        }
    }

    @Override
    public synchronized void removeItem(StringMenuItem<T> menuItem) {
        if (!EventQueue.isDispatchThread()) {
            this.log.fatal((Object)"Must be called on the EventQueue dispatch thread");
            throw new IllegalStateException("Must be called on the EventQueue dispatch thread");
        }
        if (menuItem != null) {
            this.log.trace((Object)"Looking for menu item to remove");
            JMenuItem cachedJMenuItem = this.itemStringToJMenuItem.get(menuItem);
            this.log.trace((Object)("Cache returned item: " + cachedJMenuItem));
            if (cachedJMenuItem != null) {
                ActionListener[] listeners;
                this.log.trace((Object)"Removing item from JMenu");
                this.menu.remove(cachedJMenuItem);
                this.log.trace((Object)"Removing item from key list");
                this.itemStrings.remove(menuItem);
                this.log.trace((Object)"Removing item from cache");
                this.itemStringToJMenuItem.remove(menuItem);
                this.log.trace((Object)"Removing ALL action listeners from JMenuItem");
                for (ActionListener listener : listeners = cachedJMenuItem.getActionListeners()) {
                    cachedJMenuItem.removeActionListener(listener);
                }
            }
        }
    }

    private synchronized void fireMenuItemSelected(final StringMenuItem<T> menuItem) {
        for (final StringMenuListener<T> listener : this.listeners) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringMenuImpl.this.log.trace((Object)("Informing listener:" + listener + " that item: " + menuItem + " was selected"));
                    listener.menuItemSelected(menuItem);
                }
            });
        }
    }

    public synchronized void close() {
        try {
            this.log.trace((Object)"Trying to serialize key list to preferences");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream outs = new ObjectOutputStream(baos);
            outs.writeObject(this.itemStrings);
            outs.flush();
            this.preferences.setBytes(this.preferencesKey, baos.toByteArray());
        }
        catch (BackendException e) {
            this.log.warn((Object)e);
        }
        catch (IOException e) {
            this.log.warn((Object)e);
        }
    }

    public void start() {
    }

    private synchronized void restoreMenu() {
        try {
            this.log.trace((Object)"Trying to deserialize key list from preferences");
            byte[] data = this.preferences.getBytes(this.preferencesKey);
            if (data != null) {
                ObjectInputStream ins = new ObjectInputStream(new ByteArrayInputStream(data));
                ArrayList restoredKeys = (ArrayList)ins.readObject();
                for (StringMenuItem item : restoredKeys) {
                    this.addItemInternal(item);
                }
            }
        }
        catch (InvalidDataTypeException e) {
            this.log.warn((Object)e);
        }
        catch (BackendException e) {
            this.log.warn((Object)e);
        }
        catch (IOException e) {
            this.log.warn((Object)e);
        }
        catch (ClassNotFoundException e) {
            this.log.warn((Object)e);
        }
    }

    @Override
    public void clear() {
        ArrayList keyClone = (ArrayList)this.itemStrings.clone();
        for (StringMenuItem item : keyClone) {
            this.removeItem(item);
        }
    }

    @Override
    public synchronized int getNumberOfItems() {
        int numKeys = this.itemStrings.size();
        this.log.trace((Object)("Getting the number of items on the menu: " + numKeys));
        return numKeys;
    }

    private void createJMenu(String menuName, Icon icon, String clearName, String clearTooltip) {
        this.log.trace((Object)("Creating new JMenu with name: " + menuName));
        this.menu = new JMenu(menuName);
        if (icon != null) {
            this.log.trace((Object)("Setting menu icon to " + icon));
            this.menu.setIcon(icon);
        }
        if (clearName != null) {
            this.menu.add((Action)((Object)new ClearAction(clearName, clearTooltip)));
            this.menu.add(new JSeparator(0));
        }
    }

    private synchronized void addItemInternal(StringMenuItem<T> stringMenuItem) {
        this.log.trace((Object)"Creating JMenu item");
        JMenuItem jMenuItem = this.createJMenuItem(stringMenuItem);
        this.log.trace((Object)("Adding cache entry for item: " + stringMenuItem));
        this.itemStringToJMenuItem.put(stringMenuItem, jMenuItem);
        this.log.trace((Object)"Adding key to key list");
        this.itemStrings.add(stringMenuItem);
        this.log.trace((Object)("Addin JMenuItem: " + jMenuItem + " to JMenu"));
        this.menu.insert(jMenuItem, 2);
    }

    private JMenuItem createJMenuItem(final StringMenuItem<T> stringMenuItem) {
        JMenuItem jMenuItem = new JMenuItem(stringMenuItem.getPresentationName());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringMenuImpl.this.fireMenuItemSelected(stringMenuItem);
            }
        });
        return jMenuItem;
    }

    class ClearAction
    extends AbstractTypedAction {
        public ClearAction(String name, String tooltip) {
            this.setName(name);
            if (tooltip != null) {
                this.setToolTip(tooltip);
            }
        }

        public void actionPerformed(ActionEvent e) {
            StringMenuImpl.this.clear();
        }
    }
}

