/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.stringmenu;

import java.io.Serializable;

/**
 * Listener for menu selection events.
 */
public interface StringMenuListener<T extends Comparable<T> & Serializable> {
	/**
	 * A menu selection occured.
	 * 
	 * @param menuItem
	 *            THe menu item that was selected.
	 */
	public void menuItemSelected(StringMenuItem<T> menuItem);
}
