/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.component.stringmenu;

import java.io.Serializable;

public class StringMenuItem<T extends Comparable<T> & Serializable>
implements Comparable<T>,
Serializable {
    private T value;
    private String presentationName;

    public StringMenuItem(T value, String presentationName) {
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        this.value = value;
        this.presentationName = presentationName;
        if (presentationName == null || presentationName.trim().length() < 1) {
            this.presentationName = value.toString();
            if (this.presentationName.length() > 20) {
                this.presentationName = this.presentationName.substring(this.presentationName.length() - 20);
            }
        }
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringMenuItem) {
            return this.value.equals(((StringMenuItem)obj).value);
        }
        return false;
    }

    public String toString() {
        return this.presentationName;
    }

    @Override
    public int compareTo(T o) {
        return this.value.compareTo(o);
    }
}

