/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.component.filechooser.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

public class RegExpFileFilter
extends FileFilter {
    private String description;
    private ArrayList<Pattern> patterns = new ArrayList();

    public RegExpFileFilter(String description, List<String> fileMatch) {
        this.description = description;
        if (fileMatch != null) {
            for (String patternString : fileMatch) {
                Pattern pattern = Pattern.compile(patternString);
                this.patterns.add(pattern);
            }
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

