/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.component.filechooser.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.component.filechooser.FileChooser;
import nu.zoom.swing.desktop.component.filechooser.impl.RegExpFileFilter;
import nu.zoom.swing.desktop.component.stringmenu.StringMenu;
import nu.zoom.swing.desktop.component.stringmenu.StringMenuItem;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileChooserImpl
implements FileChooser {
    private Log log = LogFactory.getLog(this.getClass());
    private RegExpFileFilter filter;
    private String preferencesKey;
    private Preferences preferences;
    private Workbench workbench;
    private StringMenu<File> menu = null;

    public FileChooserImpl(Workbench workbench, Preferences preferences, String preferencesKey, String filterDescription, List<String> fileNamePatterns) {
        this.preferencesKey = preferencesKey;
        this.preferences = preferences;
        this.workbench = workbench;
        this.filter = fileNamePatterns != null && fileNamePatterns.size() > 0 ? new RegExpFileFilter(filterDescription, fileNamePatterns) : null;
    }

    @Override
    public void setMenu(StringMenu<File> menu) {
        this.menu = menu;
    }

    @Override
    public File openFile() {
        this.log.trace((Object)"Creating file open dialog");
        JFileChooser chooser = this.getChooser();
        chooser.showOpenDialog(this.workbench.getDialogOwner());
        File file = chooser.getSelectedFile();
        this.saveLastDirectory(file);
        return file;
    }

    @Override
    public File saveFile() {
        this.log.trace((Object)"Creating file save dialog");
        JFileChooser chooser = this.getChooser();
        chooser.showSaveDialog(this.workbench.getDialogOwner());
        File file = chooser.getSelectedFile();
        this.saveLastDirectory(file);
        return file;
    }

    private JFileChooser getChooser() {
        this.log.trace((Object)"Creating a new File chooser");
        JFileChooser chooser = new JFileChooser(this.getLastDirectory());
        if (this.filter != null) {
            chooser.setFileFilter(this.filter);
        }
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        return chooser;
    }

    private String getLastDirectory() {
        this.log.trace((Object)("Trying to get last opened directory from preferences using key: " + this.preferencesKey));
        try {
            return this.preferences.getString(this.preferencesKey);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to get value from preferences", (Throwable)e);
            return null;
        }
    }

    private void saveLastDirectory(File file) {
        if (file != null && file.getParent() != null) {
            this.updateMenu(file);
            this.log.trace((Object)("Trying to save last opened directory to preferences using key: " + this.preferencesKey));
            try {
                this.preferences.setString(this.preferencesKey, file.getParent());
            }
            catch (BackendException e) {
                this.log.error((Object)"Unable to set value in preferences", (Throwable)e);
            }
        }
    }

    private void updateMenu(File file) {
        if (this.menu != null) {
            String presentationName = file.toString();
            try {
                presentationName = file.getCanonicalPath();
            }
            catch (IOException e) {
                this.log.warn((Object)("Unable to get canpnical name for file: " + file), (Throwable)e);
            }
            if (presentationName.length() > 30) {
                presentationName = "..." + presentationName.substring(presentationName.length() - 27);
            }
            StringMenuItem<File> menuItem = new StringMenuItem<File>(file, presentationName);
            this.menu.removeItem(menuItem);
            this.menu.addItem(menuItem);
        }
    }
}

