/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.stringmenu.impl;

import java.io.Serializable;
import java.util.HashMap;

import javax.swing.Icon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.component.stringmenu.StringMenu;
import nu.zoom.swing.desktop.component.stringmenu.StringMenuFactory;
import nu.zoom.swing.desktop.preferences.Preferences;
import nu.zoom.swing.desktop.worker.WorkerFactory;

/**
 * 
 */
public class StringMenuFactoryImpl implements StringMenuFactory {
	private HashMap<String, StringMenu<?>> menuCache = new HashMap<String, StringMenu<?>>();

	private Preferences preferences;

	private Workbench workbench;

	private Log log = LogFactory.getLog(getClass());

	private Messages messages;

	public StringMenuFactoryImpl(Preferences preferences, Workbench workbench,
			Messages messages) {
		this.preferences = preferences;
		this.workbench = workbench;
		this.messages = messages;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.component.stringmenu.StringMenuFactory#getCachedRecentlyUsedMenu(java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Comparable<T> & Serializable> StringMenu<T> getCachedMenu(Class<T> clazz, String preferenceKey) {
		return (StringMenu<T>)menuCache.get(preferenceKey);
	}

	/* (non-Javadoc)
	 * @see nu.zoom.swing.desktop.component.stringmenu.StringMenuFactory#getMenu(java.lang.Class, java.lang.String, java.lang.String, javax.swing.Icon)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Comparable<T> & Serializable> StringMenu<T> getMenu(Class<T> clazz, String preferenceKey, String menuPresentationName, Icon menuIcon) {
		if (!menuCache.containsKey(preferenceKey)) {
			log.trace("Creating new string menu");
			StringMenu<T> menu = new StringMenuImpl<T>(preferences, workbench,
					messages, preferenceKey, menuPresentationName, menuIcon);
			menu = WorkerFactory.decorate(menu, StringMenu.class);
			menuCache.put(preferenceKey, menu);
		}
		return (StringMenu<T>)menuCache.get(preferenceKey);
	}

}
