/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.stringmenu;

import java.io.Serializable;

import javax.swing.Icon;

/**
 * Creates string menues.
 * 
 */
public interface StringMenuFactory {
	/**
	 * Get a menu. The menu will be cached with the preferenceKey as the cache
	 * key, subsequent calls to this method with the same preference key will
	 * always return the same menu instance.
	 * 
	 * @param preferenceKey
	 *            The key to use to store the menu when the application shuts
	 *            down. Will be used to restore the menu when it is created.
	 * @param menuPresentationName
	 *            The menu will have this set as its name.
	 * @param menuIcon
	 *            The icon to set on the menu. May be null.
	 * @return A StringMenu
	 */
	public <T extends Comparable<T> & Serializable> StringMenu<T> getMenu(Class<T> clazz, String preferenceKey,
			String menuPresentationName, Icon menuIcon);

	/**
	 * Retrieve a previously created menu.
	 * 
	 * @see #getMenu(String, String, Icon)
	 * @param preferencesKey
	 *            The key used to create the menu.
	 * @return The menu or null if not created.
	 */
	public <T extends Comparable<T> & Serializable> StringMenu<T> getCachedMenu(Class<T>clazz, String preferenceKey);
}