/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.filechooser.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.component.filechooser.FileChooser;
import nu.zoom.swing.desktop.component.filechooser.FileChooserFactory;
import nu.zoom.swing.desktop.preferences.Preferences;
import nu.zoom.swing.desktop.worker.WorkerFactory;

/**
 * 
 * @author $Author: $
 * @version $Revision: $
 * 
 */
public class FileChooserFactoryImpl implements FileChooserFactory {
	private Log log = LogFactory.getLog(getClass()) ;
	private Preferences preferences;

	private Workbench workbench;

	public FileChooserFactoryImpl(Workbench workbench, Preferences preferences) {
		super();
		this.preferences = preferences;
		this.workbench = workbench;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.component.filechooser.FileChooserFactory#getFileChooser(java.lang.String,
	 *      java.lang.String, java.util.List)
	 */
	public FileChooser getFileChooser(String preferencesKey,
			String matchDescription, List<String> matchPatterns) {
		log.trace("Creating file chooser") ;
		return WorkerFactory.decorate(new FileChooserImpl(workbench,
				preferences, preferencesKey, matchDescription, matchPatterns),
				FileChooser.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.component.filechooser.FileChooserFactory#getFileChooser(java.lang.String)
	 */
	public FileChooser getFileChooser(String preferencesKey) {
		return getFileChooser(preferencesKey, null, null);
	}

}
