/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.filechooser;

import java.util.List;

/**
 * Factory service that produces FileChoosers.
 * 
 * @author $Author: $
 * @version $Revision: $
 * 
 */
public interface FileChooserFactory {
	/**
	 * Get a file chooser.
	 * 
	 * @param preferencesKey
	 *            The key used by the file chooser to store the recently used
	 *            directory and files. May not be null or empty, may not contain /,
	 *            max 80 characters.
	 * @param matchDescription
	 *            A displayble description of the filename patterns - e.g.
	 *            'Image files'. May be null.
	 * @param matchPatterns
	 *            A list of regular expressions that is used to filter the
	 *            selectable files. May be null or empty, which means that no
	 *            files should be excluded.
	 * @return A file chooser with the specified characteristics.
	 */
	public FileChooser getFileChooser(String preferencesKey,
			String matchDescription, List<String> matchPatterns);

	/**
	 * Same as calling getFileChooser(preferencesKey, null, null)
	 * 
	 * @param preferencesKey
	 * @return
	 */
	public FileChooser getFileChooser(String preferencesKey);
}
