/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component.filechooser;

import java.io.File;

import nu.zoom.swing.desktop.component.stringmenu.StringMenu;
import nu.zoom.swing.desktop.component.stringmenu.StringMenuItem;
import nu.zoom.swing.desktop.worker.EventQueuePolicy;
import nu.zoom.swing.desktop.worker.Policy;

/**
 * A JFileChooser wrapper that rememebers the last location the user opened a
 * file from. The next time open or save is called the filechooser will start in
 * the same directory. Keeps a list of last opened/saved files. This list can be
 * used to for example build a quick-open menu.
 * 
 * @author $Author: $
 * @version $Revision: $
 * 
 */
public interface FileChooser {
	/**
	 * The filechooser will update this menu when a file is selected. The menu
	 * will have an item with the file name (truncated to 20 characters) and a
	 * File object as the value.
	 * 
	 * @see StringMenuItem
	 * 
	 * @param menu
	 *            The menu to update. May be null.
	 */
	public void setMenu(StringMenu<File> menu);

	/**
	 * Pops up the FileChooser in open mode.
	 * 
	 * @return The selected file, null if the user aborted or there was an
	 *         error.
	 */
	@EventQueuePolicy(Policy.EVENT_QUEUE)
	public File openFile();

	/**
	 * Pops up the FileChooser in save mode.
	 * 
	 * @return The selected file, null if the user aborted or there was an
	 *         error.
	 */
	@EventQueuePolicy(Policy.EVENT_QUEUE)
	public File saveFile();

}
