/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.operation;

import java.util.ArrayList;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.ldap.eon.operation.OperationRunner;
import nu.zoom.swing.desktop.Workbench;

public class OperationManagerImpl
implements OperationManager {
    private ThreadGroup operationRunnerThreadGroup = new ThreadGroup("Operation manager");
    private ArrayList<OperationRunner> currentOperations = new ArrayList();
    private Workbench workbench;
    private OperationRunner operationRunner;

    public OperationManagerImpl(Workbench workbench, OperationRunner operationRunner) {
        this.workbench = workbench;
        this.operationRunner = operationRunner;
    }

    @Override
    public synchronized void operationStarting(OperationRunner operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation can not be null");
        }
        this.workbench.startWorkIndicator();
        this.currentOperations.add(operation);
    }

    @Override
    public synchronized void operationFinished(OperationRunner operation) {
        this.currentOperations.remove(operation);
        this.workbench.stopWorkIndicator();
    }

    @Override
    public void runOperation(final Operation operation) {
        Thread runThread = new Thread(this.operationRunnerThreadGroup, new Runnable(){

            @Override
            public void run() {
                OperationManagerImpl.this.operationRunner.run(operation);
            }
        });
        runThread.setName("OperationRunner");
        runThread.start();
    }
}

