/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.swing.Icon;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboard;
import nu.zoom.ldap.eon.directory.tree.DirectoryTree;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class PasteItem
implements DirectoryTreePopUpItem {
    private Workbench workbench;
    private Messages messages;
    private DirectoryClipboard clipboard;

    public PasteItem(Messages messages, DirectoryClipboard clipboard, Workbench workbench) {
        this.clipboard = clipboard;
        this.messages = messages;
        this.workbench = workbench;
    }

    @Override
    public void activate(DirectoryTree tree) {
        try {
            DirectoryTreeObject selectedName = tree.getSelectedNode();
            if (selectedName != null) {
                this.clipboard.triggerPasteAction(selectedName);
            }
        }
        catch (Exception e) {
            this.workbench.getErrorReporter().reportError(e);
        }
    }

    @Override
    public String getName() {
        return this.messages.getMessage("tree.popup.paste");
    }

    @Override
    public String getToolTip() {
        return this.messages.getMessage("tree.popup.copy.tooltip");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Integer getMnemonic() {
        return new Integer(80);
    }

    @Override
    public Integer getAcceleratorKey() {
        return new Integer(86);
    }

    @Override
    public Integer getAcceleratorKeyMask() {
        return new Integer(128);
    }
}

