/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nu.zoom.ldap.eon.connection.ConnectionInformation;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListener;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeNode;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeSelectionListener;
import nu.zoom.ldap.eon.event.ActionUtils;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import org.ops4j.gaderian.Messages;

public class DirectoryTree
extends JComponent
implements TreeSelectionListener,
DirectoryEventListener {
    private ConnectionInformation connectionDescription;
    private DefaultTreeModel treeModel;
    private Workbench workbench;
    private Messages messages;
    private InitialLdapContext iCtx;
    private OperationManager manager;
    private List<DirectoryTreePopUpItem> popupItems;
    private List<DirectoryTreeSelectionListener> selectionChangeListeners = new ArrayList<DirectoryTreeSelectionListener>();
    private JPopupMenu popupMenu;
    private JTree tree;

    public DirectoryTree(OperationManager manager, Workbench workbench, Messages messages, InitialLdapContext iCtx, ConnectionInformation connectionDescription, List<DirectoryTreePopUpItem> popupItems) {
        this.iCtx = iCtx;
        this.messages = messages;
        this.workbench = workbench;
        this.manager = manager;
        this.connectionDescription = connectionDescription;
        this.popupItems = popupItems;
        if (EventQueue.isDispatchThread()) {
            this.buildGUI();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DirectoryTree.this.buildGUI();
                }
            });
        }
    }

    public void showDN(Name dn) {
        String namePart;
        DirectoryTreeNode child;
        if (this.treeModel == null || this.treeModel.getRoot() == null) {
            return;
        }
        DirectoryTreeNode currentLdapTreeNode = (DirectoryTreeNode)this.treeModel.getRoot();
        TreePath path = new TreePath(currentLdapTreeNode);
        for (int i = 0; i < dn.size() && (child = currentLdapTreeNode.getChildWithRDN(namePart = dn.get(i))) != null; ++i) {
            path = path.pathByAddingChild(child);
            currentLdapTreeNode = child;
        }
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
        this.tree.validate();
    }

    public void refresh(Name dn) {
        String namePart;
        DirectoryTreeNode child;
        if (this.treeModel == null || this.treeModel.getRoot() == null) {
            return;
        }
        DirectoryTreeNode currentLdapTreeNode = (DirectoryTreeNode)this.treeModel.getRoot();
        for (int i = 0; i < dn.size() && (child = currentLdapTreeNode.getChildWithRDN(namePart = dn.get(i))) != null; ++i) {
            currentLdapTreeNode = child;
        }
        currentLdapTreeNode.clearChildCache();
    }

    public synchronized void addDirectoryTreeSelectionListener(DirectoryTreeSelectionListener listener) {
        if (listener != null) {
            this.selectionChangeListeners.add(listener);
        }
    }

    public synchronized void removeDirectoryTreeSelectionListener(DirectoryTreeSelectionListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    private void buildGUI() {
        this.treeModel = new DefaultTreeModel(null);
        try {
            DirectoryTreeNode rootNode = new DirectoryTreeNode(this, this.workbench, this.messages, this.manager, this.treeModel, this.iCtx, null, "");
            this.treeModel.setRoot(rootNode);
        }
        catch (NamingException exc) {
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("error.tree.rootnode"), (Exception)exc);
        }
        this.tree = new JTree(this.treeModel);
        this.popupMenu = new JPopupMenu(this.messages.getMessage("tree.popupmenu"));
        for (DirectoryTreePopUpItem item : this.popupItems) {
            this.popupMenu.add(new PopupAction(item));
        }
        this.tree.addMouseListener(new PopupListener());
        this.tree.addTreeSelectionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    @Override
    public synchronized void valueChanged(TreeSelectionEvent e) {
        for (int i = 0; i < this.selectionChangeListeners.size(); ++i) {
            this.selectionChangeListeners.get(i).selectionChanged(this, this.iCtx);
        }
    }

    public DirectoryTreeObject getSelectedNode() throws NamingException {
        TreePath selectedPath = this.tree.getSelectionPath();
        if (selectedPath != null) {
            DirectoryTreeNode selectedNode = (DirectoryTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            return selectedNode.getObject();
        }
        return null;
    }

    public DirectoryTreeObject[] getSelectedNodes() throws NamingException {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths != null) {
            DirectoryTreeObject[] selectedNames = new DirectoryTreeObject[selectedPaths.length];
            for (int i = 0; i < selectedPaths.length; ++i) {
                DirectoryTreeNode selectedNode = (DirectoryTreeNode)selectedPaths[i].getLastPathComponent();
                selectedNames[i] = selectedNode.getObject();
            }
            return selectedNames;
        }
        return null;
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connectionDescription;
    }

    public InitialLdapContext getConnection() {
        return this.iCtx;
    }

    @Override
    public void structureChanged(Name name) {
        this.refresh(name);
        this.tree.invalidate();
        this.repaint();
    }

    @Override
    public void attributesChanged(Name name) {
    }

    class PopupAction
    extends AbstractAction {
        private DirectoryTreePopUpItem item;

        PopupAction(DirectoryTreePopUpItem item) {
            this.item = item;
            ActionUtils.setActionValues(this, item, DirectoryTree.this.tree);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.item.activate(DirectoryTree.this);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = DirectoryTree.this.tree.getRowForLocation(e.getX(), e.getY());
                if (DirectoryTree.this.tree.getSelectionCount() < 2) {
                    DirectoryTree.this.tree.setSelectionRow(row);
                }
                DirectoryTree.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

