/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.Name;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListener;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;

public class EventListenerRegistryImpl
implements DirectoryEventListenerRegistry {
    private HashMap<ConnectionGUID, List<DirectoryEventListener>> connectionMap = new HashMap();

    @Override
    public synchronized void addEventListener(ConnectionGUID connection, DirectoryEventListener listener) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        List<DirectoryEventListener> listeners = this.connectionMap.get(connection);
        if (listeners == null) {
            listeners = new ArrayList<DirectoryEventListener>();
            this.connectionMap.put(connection, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public synchronized void removeEventListener(DirectoryEventListener listener) {
        Collection<List<DirectoryEventListener>> listenerRegistries = this.connectionMap.values();
        for (List<DirectoryEventListener> registry : listenerRegistries) {
            registry.remove(listener);
        }
    }

    @Override
    public synchronized void fireStructureChanged(ConnectionGUID connection, final Name name) {
        List<DirectoryEventListener> listeners = this.connectionMap.get(connection);
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                final DirectoryEventListener listener = listeners.get(i);
                Thread listenerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.structureChanged(name);
                    }
                });
                listenerThread.setDaemon(true);
                listenerThread.start();
            }
        }
    }

    @Override
    public synchronized void fireAttributesChanged(ConnectionGUID connection, final Name name) {
        List<DirectoryEventListener> listeners = this.connectionMap.get(connection);
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                final DirectoryEventListener listener = listeners.get(i);
                Thread listenerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.attributesChanged(name);
                    }
                });
                listenerThread.setDaemon(true);
                listenerThread.start();
            }
        }
    }
}

