/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.attributes;

import java.util.ArrayList;
import java.util.Collections;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.swing.table.AbstractTableModel;
import nu.zoom.ldap.eon.directory.attributes.AttributeTableRow;

public class AttributesTableModel
extends AbstractTableModel {
    private ArrayList<AttributeTableRow> attributeRows = new ArrayList();
    private String[] headernames = new String[2];

    public AttributesTableModel(String nameHeader, String valueHeader) {
        this.headernames[0] = nameHeader;
        this.headernames[1] = valueHeader;
    }

    public void resetModel(Attributes attrs) throws NamingException {
        if (attrs == null) {
            throw new IllegalArgumentException("Attributes can not be null");
        }
        this.attributeRows.clear();
        NamingEnumeration<? extends Attribute> attributeEnumeration = attrs.getAll();
        while (attributeEnumeration.hasMore()) {
            Attribute attr = attributeEnumeration.next();
            String name = attr.getID();
            NamingEnumeration<?> attributeValueEnumeration = attr.getAll();
            while (attributeValueEnumeration.hasMore()) {
                Object attrValue = attributeValueEnumeration.next();
                String presentationValue = attrValue instanceof String ? (String)attrValue : "...";
                AttributeTableRow row = new AttributeTableRow();
                row.setAttribute(attr);
                row.setId(name);
                row.setValue(presentationValue);
                this.attributeRows.add(row);
            }
        }
        Collections.sort(this.attributeRows);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.attributeRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.headernames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.attributeRows.get(rowIndex).getId();
            }
            case 1: {
                return this.attributeRows.get(rowIndex).getValue();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.headernames.length) {
            return this.headernames[column];
        }
        return super.getColumnName(column);
    }

    public Attribute getAttributeAt(int row) {
        return this.attributeRows.get(row).getAttribute();
    }
}

