/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.directory.attributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import nu.zoom.ldap.eon.connection.ConnectionInformation;
import nu.zoom.ldap.eon.directory.attributes.AddAttributeDialog;
import nu.zoom.ldap.eon.directory.attributes.AttributeEditor;
import nu.zoom.ldap.eon.directory.attributes.AttributeEditorFactory;
import nu.zoom.ldap.eon.directory.attributes.AttributesTableModel;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListener;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.action.WorkbenchAction;
import org.ops4j.gaderian.Messages;

public class AllAttributesComponent
extends JComponent
implements MouseListener,
DirectoryEventListener {
    private Workbench workbench;
    private Messages messages;
    private AttributeEditorFactory editorFactory;
    private Name dn;
    private JTable attributesTable;
    private AttributesTableModel model;
    private InitialLdapContext iCtx;
    private JPopupMenu popupMenu;
    private ConnectionInformation connectionInformation;

    public AllAttributesComponent(Workbench workbench, Messages messages, AttributeEditorFactory editorFactory, InitialLdapContext iCtx, ConnectionInformation connectionInformation) {
        this.messages = messages;
        this.workbench = workbench;
        this.editorFactory = editorFactory;
        this.iCtx = iCtx;
        this.connectionInformation = connectionInformation;
        if (EventQueue.isDispatchThread()) {
            this.buildGUI();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AllAttributesComponent.this.buildGUI();
                }
            });
        }
    }

    private void buildGUI() {
        this.model = new AttributesTableModel(this.messages.getMessage("attributes.table.header.id"), this.messages.getMessage("attributes.table.header.value"));
        this.attributesTable = new JTable(this.model);
        this.attributesTable.setAutoResizeMode(0);
        TableColumnModel columnModel = this.attributesTable.getColumnModel();
        for (int c = 0; c < columnModel.getColumnCount(); ++c) {
            columnModel.getColumn(c).setPreferredWidth(250);
        }
        JScrollPane attributesTableScroller = new JScrollPane(this.attributesTable);
        this.setLayout(new BorderLayout());
        this.add((Component)attributesTableScroller, "Center");
        this.validate();
        this.popupMenu = new JPopupMenu();
        AddAttributeAction addAttributeAction = new AddAttributeAction();
        this.popupMenu.add((Action)((Object)addAttributeAction));
        this.attributesTable.addMouseListener(this);
    }

    public void show(Name dn, final Attributes attributes) throws NamingException {
        this.dn = dn;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AllAttributesComponent.this.model.resetModel(attributes);
                }
                catch (NamingException e) {
                    AllAttributesComponent.this.workbench.getErrorReporter().reportError(AllAttributesComponent.this.messages.getMessage("error.attributes.show"), (Exception)e);
                }
            }
        });
    }

    private void editSelectedAttribute() {
        Attribute attr = this.getSelectedAttribute();
        if (attr != null) {
            try {
                AttributeEditor editor = this.editorFactory.getEditor(attr);
                editor.edit(this.connectionInformation, this.iCtx, this.dn, attr);
            }
            catch (NamingException e) {
                this.workbench.getErrorReporter().reportError((Exception)e);
            }
        } else {
            this.workbench.getErrorReporter().reportError(this.messages.getMessage("attributes.noselected"));
        }
    }

    private Attribute getSelectedAttribute() {
        TableModel tableModel;
        Attribute attr = null;
        int selectedRow = this.attributesTable.getSelectedRow();
        if (selectedRow >= 0 && (tableModel = this.attributesTable.getModel()) != null && tableModel instanceof AttributesTableModel) {
            attr = ((AttributesTableModel)tableModel).getAttributeAt(selectedRow);
        }
        return attr;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int rowAt;
        if (e.getButton() == 3 && (rowAt = this.attributesTable.rowAtPoint(e.getPoint())) >= 0) {
            this.attributesTable.setRowSelectionInterval(rowAt, rowAt);
        }
        if (e.getClickCount() == 2) {
            this.editSelectedAttribute();
        }
    }

    @Override
    public void attributesChanged(Name name) {
        if (name.equals(this.dn)) {
            try {
                this.show(this.dn, this.iCtx.getAttributes(this.dn));
            }
            catch (NamingException e) {
                this.workbench.getErrorReporter().reportError((Exception)e);
            }
        }
    }

    @Override
    public void structureChanged(Name name) {
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class AddAttributeAction
    extends WorkbenchAction {
        AddAttributeAction() {
            this.setName(AllAttributesComponent.this.messages.getMessage("attributes.popup.add"));
            this.setToolTip(AllAttributesComponent.this.messages.getMessage("attributes.popup.add.tooltip"));
        }

        public void actionPerformed(ActionEvent e) {
            AddAttributeDialog dlg = new AddAttributeDialog(AllAttributesComponent.this.workbench, AllAttributesComponent.this.messages);
            dlg.pack();
            dlg.setLocationRelativeTo(AllAttributesComponent.this.workbench.getDialogOwner());
            dlg.setVisible(true);
            String attributeID = dlg.getText();
            if (attributeID != null) {
                AttributeEditor editor = AllAttributesComponent.this.editorFactory.getEditor(attributeID);
                editor.create(AllAttributesComponent.this.connectionInformation, AllAttributesComponent.this.iCtx, AllAttributesComponent.this.dn, attributeID);
            }
        }
    }
}

