/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection.password;

import java.awt.EventQueue;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import nu.zoom.ldap.eon.connection.password.AnonymousConnection;
import nu.zoom.ldap.eon.connection.password.PasswordDialog;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import org.ops4j.gaderian.Messages;

public class UserConnection
extends AnonymousConnection {
    static final long serialVersionUID = -7973745137178679985L;
    private String username;
    private transient Workbench workbench = null;
    private transient Messages messages = null;

    @Override
    public synchronized InitialLdapContext getConnection() throws BackendException {
        if (this.workbench == null || this.messages == null) {
            throw new IllegalStateException(UserConnection.class.getName() + " is not initalized properly - workbench or messages are null.");
        }
        final PasswordQueryMutex result = new PasswordQueryMutex();
        if (EventQueue.isDispatchThread()) {
            this.getPasswordOnEventThread(result);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public synchronized void run() {
                    UserConnection.this.getPasswordOnEventThread(result);
                    this.notifyAll();
                }
            });
            while (!result.isReady()) {
                try {
                    this.wait(123L);
                }
                catch (InterruptedException exc) {}
            }
        }
        if (result.isCloseOK()) {
            Hashtable env = new Hashtable();
            this.setupEnvironment(env, this.getUsername(), result.getPassword());
            try {
                InitialLdapContext iCtx = new InitialLdapContext(env, null);
                return iCtx;
            }
            catch (NamingException e) {
                throw new BackendException((Throwable)e);
            }
        }
        return null;
    }

    protected void setupEnvironment(Hashtable env, String username, char[] password) {
        this.setupEnvironment(env);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private void getPasswordOnEventThread(PasswordQueryMutex mutex) {
        PasswordDialog dlg = new PasswordDialog(this.workbench, this.messages);
        dlg.setVisible(true);
        mutex.closeOK = dlg.isCloseOK();
        if (mutex.closeOK) {
            mutex.password = dlg.getPassword();
        }
        mutex.setRead();
    }

    class PasswordQueryMutex {
        private boolean ready = false;
        char[] password = null;
        boolean closeOK = false;

        PasswordQueryMutex() {
        }

        synchronized boolean isReady() {
            return this.ready;
        }

        synchronized void setRead() {
            this.ready = true;
        }

        char[] getPassword() {
            return this.password;
        }

        boolean isCloseOK() {
            return this.closeOK;
        }
    }
}

