/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection.password;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import nu.zoom.ldap.eon.connection.AbstractConnectionFactory;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionEditor;
import nu.zoom.ldap.eon.connection.password.PasswordConnectionEditor;
import nu.zoom.ldap.eon.connection.password.UserConnection;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.ops4j.gaderian.Messages;

public class PasswordConnectionFactory
extends AbstractConnectionFactory {
    private static final String PREFS_PREFIX = "PasswordConnectionFactory.";
    private static final String PREFS_CONNECTION_IDS = "PasswordConnectionFactory.Collection";
    private Preferences preferences;
    private Workbench workbench;
    private Messages messages;
    private ComponentFactory componentFactory;
    private OperationManager operationManager;

    public PasswordConnectionFactory(Preferences preferences, Workbench workbench, Messages messages, ComponentFactory componentFactory, OperationManager operationManager) {
        this.preferences = preferences;
        this.workbench = workbench;
        this.messages = messages;
        this.componentFactory = componentFactory;
        this.operationManager = operationManager;
    }

    @Override
    public Connection[] listConnections() throws BackendException {
        try {
            ArrayList<Connection> connections = new ArrayList<Connection>();
            Set connectionIDs = this.preferences.getStrings(PREFS_CONNECTION_IDS);
            for (String connectionID : connectionIDs) {
                byte[] serialConnection = this.preferences.getBytes(PREFS_PREFIX + connectionID);
                if (serialConnection != null) {
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serialConnection));
                        Connection connection = (Connection)in.readObject();
                        connections.add(connection);
                        if (!(connection instanceof UserConnection)) continue;
                        ((UserConnection)connection).setWorkbench(this.workbench);
                        ((UserConnection)connection).setMessages(this.messages);
                        continue;
                    }
                    catch (Exception exc1) {
                        throw new BackendException((Throwable)exc1);
                    }
                }
                throw new BackendException("Preferences out of sync, listed connection is missing data.");
            }
            return connections.toArray(new Connection[connections.size()]);
        }
        catch (InvalidDataTypeException exc) {
            throw new BackendException("Unable to get collection of connection names", (Throwable)exc);
        }
    }

    @Override
    protected void delegateAddConnection(Connection connection) throws BackendException {
        try {
            Set connectionIDs = this.preferences.getStrings(PREFS_CONNECTION_IDS);
            HashSet<String> newSet = new HashSet<String>(connectionIDs);
            newSet.add(connection.getGUID().toString());
            this.preferences.setStrings(PREFS_CONNECTION_IDS, newSet);
            this.saveConnection(connection);
        }
        catch (Exception exc) {
            throw new BackendException((Throwable)exc);
        }
    }

    @Override
    protected void delegateRemoveConnection(Connection connection) throws BackendException {
        String connectionID = connection.getGUID().toString();
        this.preferences.setBytes(PREFS_PREFIX + connection.getGUID().toString(), null);
        try {
            Set connectionIDs = this.preferences.getStrings(PREFS_CONNECTION_IDS);
            HashSet newSet = new HashSet(connectionIDs);
            newSet.remove(connectionID);
            this.preferences.setStrings(PREFS_CONNECTION_IDS, newSet);
        }
        catch (InvalidDataTypeException exc) {
            throw new BackendException((Throwable)exc);
        }
    }

    @Override
    protected void delegateConnectionChanged(Connection connection) throws BackendException {
        try {
            this.saveConnection(connection);
        }
        catch (IOException exc) {
            throw new BackendException((Throwable)exc);
        }
    }

    @Override
    public String getDescription() {
        return this.messages.getMessage("connection.password.description");
    }

    @Override
    public String getName() {
        return this.messages.getMessage("connection.password.name");
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public ConnectionEditor getEditor() {
        return new PasswordConnectionEditor(this.workbench, this.messages, this, this.componentFactory, this.operationManager);
    }

    private void saveConnection(Connection connection) throws IOException, BackendException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(connection);
        this.preferences.setBytes(PREFS_PREFIX + connection.getGUID().toString(), baos.toByteArray());
    }
}

