/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection.password;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import nu.zoom.ldap.eon.connection.AbstractConnectionFactory;
import nu.zoom.ldap.eon.connection.ConnectOperation;
import nu.zoom.ldap.eon.connection.Connection;
import nu.zoom.ldap.eon.connection.ConnectionEditor;
import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.connection.password.AnonymousConnection;
import nu.zoom.ldap.eon.connection.password.UserConnection;
import nu.zoom.ldap.eon.connection.password.UserPasswordConnection;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.ldap.eon.util.MessagesUtil;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.layout.VerticalPanel;
import org.ops4j.gaderian.Messages;

public class PasswordConnectionEditor
extends JComponent
implements ConnectionEditor {
    private Messages messages;
    private AbstractConnectionFactory factory;
    private Workbench workbench;
    private WorkbenchFrame ownerFrame = null;
    private ComponentFactory componentFactory;
    private OperationManager operationManager;
    private static final int CREDENTIALS_FIELD_COLUMNS = 50;
    private static final int PRINCIPAL_FIELD_COLUMNS = 50;
    private static final int PORT_FIELD_COLUMNS = 5;
    private static final int HOST_FIELD_COLUMNS = 50;
    private static final int NAME_FIELD_COLUMNS = 50;
    private static final int ROOT_CONTEXT_FIELD_COLUMNS = 50;
    private static final int MIN_ALLOWED_POTNUMBER = 1;
    private static final int MAX_ALLOWED_PORTNUMBER = 65535;
    private JTextField nameField;
    private JTextField hostField;
    private JTextField portField;
    private JTextField principalField;
    private JTextField rootContextField;
    private JPasswordField credentialsField;
    private JCheckBox anonymousCheckBox;
    private JCheckBox saveCredentialsBox;
    private boolean editingExistingEntry;
    private JLabel headerLabel;
    private JButton okButton;
    private JButton connectButton;
    private Connection connection = null;

    public PasswordConnectionEditor(Workbench workbench, Messages messages, AbstractConnectionFactory factory, ComponentFactory componentFactory, OperationManager operationManager) {
        this.messages = messages;
        this.factory = factory;
        this.workbench = workbench;
        this.componentFactory = componentFactory;
        this.operationManager = operationManager;
        this.buildGUI();
    }

    @Override
    public JComponent createNewConnectionEditor() {
        this.initNewConnection();
        return this;
    }

    @Override
    public JComponent editConnection(Connection connection) {
        this.connection = connection;
        this.initEditConnection();
        return this;
    }

    private void initNewConnection() {
        this.editingExistingEntry = false;
        this.headerLabel.setText(this.messages.getMessage("connection.password.header.new"));
        this.hostField.setText("localhost");
        this.portField.setText("389");
        this.rootContextField.setText("");
        this.anonymousCheckBox.setSelected(false);
        this.saveCredentialsBox.setSelected(false);
        this.principalField.setText("");
        this.credentialsField.setText("");
        this.nameField.setText("");
    }

    private void initEditConnection() {
        this.editingExistingEntry = true;
        this.headerLabel.setText(this.messages.getMessage("connection.password.header.edit"));
        this.hostField.setText(((AnonymousConnection)this.connection).getHost());
        this.portField.setText("" + ((AnonymousConnection)this.connection).getPort());
        this.nameField.setText(((AnonymousConnection)this.connection).getDescription());
        this.rootContextField.setText(((AnonymousConnection)this.connection).getRootContext());
        if (this.connection instanceof UserConnection) {
            this.anonymousCheckBox.setSelected(false);
            this.saveCredentialsBox.setSelected(false);
            this.principalField.setText(((UserConnection)this.connection).getUsername());
            this.credentialsField.setText("");
        } else if (this.connection instanceof AnonymousConnection) {
            this.anonymousCheckBox.setSelected(true);
            this.saveCredentialsBox.setSelected(false);
            this.principalField.setText("");
            this.credentialsField.setText("");
        } else {
            this.anonymousCheckBox.setSelected(false);
            this.saveCredentialsBox.setSelected(false);
            this.principalField.setText(((UserPasswordConnection)this.connection).getUsername());
            this.credentialsField.setText(new String(((UserPasswordConnection)this.connection).getPassword()));
        }
    }

    private void buildGUI() {
        JLabel bannerLabel = new JLabel(MessagesUtil.getIconFromMessages(this.messages, "dialog.banner"));
        this.headerLabel = new JLabel();
        this.nameField = new JTextField(50);
        this.hostField = new JTextField(50);
        this.portField = new JTextField(5);
        this.rootContextField = new JTextField(50);
        this.credentialsField = new JPasswordField(50);
        this.anonymousCheckBox = new JCheckBox("");
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordConnectionEditor.this.principalField.setEnabled(!PasswordConnectionEditor.this.anonymousCheckBox.isSelected());
                if (PasswordConnectionEditor.this.anonymousCheckBox.isSelected()) {
                    PasswordConnectionEditor.this.credentialsField.setEnabled(false);
                } else {
                    PasswordConnectionEditor.this.credentialsField.setEnabled(PasswordConnectionEditor.this.saveCredentialsBox.isSelected());
                }
                PasswordConnectionEditor.this.saveCredentialsBox.setEnabled(!PasswordConnectionEditor.this.anonymousCheckBox.isSelected());
            }
        });
        this.saveCredentialsBox = new JCheckBox(this.messages.getMessage("connection.password.save"));
        this.saveCredentialsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordConnectionEditor.this.credentialsField.setEnabled(PasswordConnectionEditor.this.saveCredentialsBox.isSelected());
            }
        });
        this.saveCredentialsBox.setToolTipText(this.messages.getMessage("connection.password.save.tooltip"));
        this.credentialsField.setEnabled(false);
        this.principalField = new JTextField(50);
        this.credentialsField.setEnabled(false);
        JLabel connectionNameLabel = new JLabel(this.messages.getMessage("connection.password.connectionname"));
        JLabel hostnameLabel = new JLabel(this.messages.getMessage("connection.password.host"));
        JLabel portLabel = new JLabel(this.messages.getMessage("connection.password.portnumber"));
        JLabel rootContextLabel = new JLabel(this.messages.getMessage("connection.password.context"));
        JLabel anonymousLabel = new JLabel(this.messages.getMessage("connection.password.anonymous"));
        JLabel principalLabel = new JLabel(this.messages.getMessage("connection.password.principal"));
        this.connectButton = new JButton(this.messages.getMessage("connection.password.connect"));
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordConnectionEditor.this.validateFields()) {
                    PasswordConnectionEditor.this.createConnection();
                    ConnectOperation operation = new ConnectOperation(PasswordConnectionEditor.this.workbench, PasswordConnectionEditor.this.messages, PasswordConnectionEditor.this.connection, PasswordConnectionEditor.this.componentFactory);
                    PasswordConnectionEditor.this.operationManager.runOperation(operation);
                }
            }
        });
        this.okButton = new JButton(this.messages.getMessage("connection.password.ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordConnectionEditor.this.validateFields()) {
                    PasswordConnectionEditor.this.createConnection();
                    if (PasswordConnectionEditor.this.editingExistingEntry) {
                        try {
                            PasswordConnectionEditor.this.factory.connectionChanged(PasswordConnectionEditor.this.connection);
                            PasswordConnectionEditor.this.headerLabel.setText(PasswordConnectionEditor.this.messages.getMessage("connection.password.saved"));
                        }
                        catch (BackendException exc) {
                            PasswordConnectionEditor.this.workbench.getErrorReporter().reportError((Exception)((Object)exc));
                        }
                    } else {
                        try {
                            PasswordConnectionEditor.this.factory.addConnection(PasswordConnectionEditor.this.connection);
                            PasswordConnectionEditor.this.headerLabel.setText(PasswordConnectionEditor.this.messages.getMessage("connection.password.created"));
                            PasswordConnectionEditor.this.okButton.setEnabled(false);
                            if (PasswordConnectionEditor.this.ownerFrame != null) {
                                PasswordConnectionEditor.this.ownerFrame.dispose();
                            }
                        }
                        catch (BackendException exc) {
                            PasswordConnectionEditor.this.workbench.getErrorReporter().reportError((Exception)((Object)exc));
                        }
                    }
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.connectButton);
        buttonPanel.add(this.okButton);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.addRow((JComponent)bannerLabel, (JComponent)this.headerLabel);
        mainPanel.addRow((JComponent)connectionNameLabel, (JComponent)this.nameField);
        mainPanel.addRow((JComponent)hostnameLabel, (JComponent)this.hostField);
        mainPanel.addRow((JComponent)portLabel, (JComponent)this.portField);
        mainPanel.addRow((JComponent)rootContextLabel, (JComponent)this.rootContextField);
        mainPanel.addRow((JComponent)anonymousLabel, (JComponent)this.anonymousCheckBox);
        mainPanel.addRow((JComponent)principalLabel, (JComponent)this.principalField);
        mainPanel.addRow((JComponent)this.saveCredentialsBox, (JComponent)this.credentialsField);
        mainPanel.addRow((JComponent)buttonPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
    }

    private boolean validateFields() {
        String principal;
        String host = this.hostField.getText();
        if (host == null || host.trim().length() < 1) {
            this.complain("connection.password.error.missing.host");
            return false;
        }
        String port = this.portField.getText();
        if (port == null || port.trim().length() < 1) {
            this.complain("connection.password.error.missing.port");
            return false;
        }
        try {
            int portNum = Integer.parseInt(port);
            if (portNum < 1 || portNum > 65535) {
                this.complain("connection.password.error.port.invalid");
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.complain("connection.password.error.port.invalid");
            return false;
        }
        if (!(this.anonymousCheckBox.isSelected() || (principal = this.principalField.getText()) != null && principal.trim().length() >= 1)) {
            this.complain("connection.password.error.missing.principal");
            return false;
        }
        String name = this.nameField.getText();
        if (name == null || name.trim().length() < 1) {
            this.complain("connection.password.error.missing.name");
            return false;
        }
        return true;
    }

    private void complain(String messageKey) {
        this.workbench.getErrorReporter().reportError(this.messages.getMessage(messageKey));
    }

    private void createConnection() {
        ConnectionGUID connectionGUID = null;
        if (this.connection != null) {
            connectionGUID = this.connection.getGUID();
        }
        this.connection = this.anonymousCheckBox.isSelected() ? new AnonymousConnection() : (this.saveCredentialsBox.isSelected() ? new UserPasswordConnection() : new UserConnection());
        if (connectionGUID != null) {
            ((AnonymousConnection)this.connection).setGUID(connectionGUID);
        }
        if (this.connection instanceof UserPasswordConnection) {
            ((UserPasswordConnection)this.connection).setPassword(this.credentialsField.getPassword());
        }
        if (this.connection instanceof UserConnection) {
            ((UserConnection)this.connection).setUsername(this.principalField.getText().trim());
            ((UserConnection)this.connection).setMessages(this.messages);
            ((UserConnection)this.connection).setWorkbench(this.workbench);
        }
        if (this.connection instanceof AnonymousConnection) {
            ((AnonymousConnection)this.connection).setHost(this.hostField.getText().trim());
            ((AnonymousConnection)this.connection).setPort(Integer.parseInt(this.portField.getText()));
            ((AnonymousConnection)this.connection).setDescription(this.nameField.getText().trim());
            if (this.rootContextField.getText().trim().length() < 1) {
                ((AnonymousConnection)this.connection).setRootContext(null);
            } else {
                ((AnonymousConnection)this.connection).setRootContext(this.rootContextField.getText().trim());
            }
        }
    }

    @Override
    public void setOwnerFrame(WorkbenchFrame frame) {
        this.ownerFrame = frame;
    }
}

