/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection.dns;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.table.StringTableModel;
import nu.zoom.util.dns.Resolver;
import nu.zoom.util.dns.SRVRecord;
import org.ops4j.gaderian.Messages;

public class FindServersPanel
extends JPanel {
    private final Messages messages;
    private final OperationManager operationManager;
    private final Workbench workbench;
    private final Resolver resolver;
    private final StringTableModel resultTableModel;
    private JTextField domainNameField;
    private JLabel domainNameFieldLabel;
    private JButton lookupButton;
    private JProgressBar lookupProgressBar;
    private JScrollPane resultScrollPane;
    private JTable resultTable;

    public FindServersPanel(Messages messages, OperationManager operationManager, Workbench workbench, Resolver resolver) {
        this.messages = messages;
        this.operationManager = operationManager;
        this.workbench = workbench;
        this.resolver = resolver;
        String[] columnNames = new String[]{messages.getMessage("connection.dns.result.table.host"), messages.getMessage("connection.dns.result.table.address"), messages.getMessage("connection.dns.result.table.port"), messages.getMessage("connection.dns.result.table.prio"), messages.getMessage("connection.dns.result.table.weight")};
        this.resultTableModel = new StringTableModel(columnNames);
        this.initComponents();
        operationManager.runOperation(new CanonicalHostNameOperation());
    }

    private void initComponents() {
        this.domainNameField = new JTextField();
        this.domainNameFieldLabel = new JLabel();
        this.resultScrollPane = new JScrollPane();
        this.resultTable = new JTable();
        this.lookupProgressBar = new JProgressBar();
        this.lookupButton = new JButton();
        this.domainNameFieldLabel.setLabelFor(this.domainNameField);
        this.domainNameFieldLabel.setText(this.messages.getMessage("connection.dns.domainlabel"));
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultScrollPane.setViewportView(this.resultTable);
        this.lookupButton.setText(this.messages.getMessage("connection.dns.domainbutton"));
        this.lookupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindServersPanel.this.lookupButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultScrollPane, GroupLayout.Alignment.LEADING, -1, 394, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.domainNameFieldLabel).addGap(18, 18, 18).addComponent(this.domainNameField, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lookupButton)).addComponent(this.lookupProgressBar, -1, 394, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainNameFieldLabel).addComponent(this.domainNameField, -2, -1, -2).addComponent(this.lookupButton)).addGap(18, 18, 18).addComponent(this.resultScrollPane, -1, 199, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lookupProgressBar, -2, -1, -2).addContainerGap()));
    }

    private void lookupButtonActionPerformed(ActionEvent evt) {
        this.lookupProgressBar.setIndeterminate(true);
        this.workbench.startWorkIndicator();
        String lookup = "_ldap._tcp." + this.domainNameField.getText();
        String message = this.messages.format("connection.dns.lookup", (Object)lookup);
        this.workbench.setStatusbarMessage(message);
        this.lookupButton.setEnabled(false);
        this.resultTableModel.clear();
        this.operationManager.runOperation(new FindADServersOperation(lookup));
    }

    class FindADServersOperation
    implements Operation {
        private final String lookupName;

        public FindADServersOperation(String lookupName) {
            this.lookupName = lookupName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            Hashtable<SRVRecord, List> result = new Hashtable<SRVRecord, List>();
            try {
                List srvRecords = FindServersPanel.this.resolver.lookupSRV(this.lookupName);
                for (SRVRecord srvRecord : srvRecords) {
                    List addresses = FindServersPanel.this.resolver.lookupA(srvRecord.getHostname());
                    result.put(srvRecord, addresses);
                }
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new Runnable(result){
                    final /* synthetic */ Hashtable val$result;
                    {
                        this.val$result = hashtable;
                    }

                    @Override
                    public void run() {
                        FindServersPanel.this.lookupProgressBar.setIndeterminate(false);
                        FindServersPanel.this.workbench.stopWorkIndicator();
                        if (this.val$result.size() < 1) {
                            FindServersPanel.this.workbench.setStatusbarMessage(FindServersPanel.this.messages.format("connection.dns.noresults", (Object)FindADServersOperation.this.lookupName));
                        } else {
                            Set resultSet = this.val$result.entrySet();
                            for (Map.Entry entry : resultSet) {
                                SRVRecord srv = (SRVRecord)entry.getKey();
                                FindServersPanel.this.resultTableModel.addEntry(srv.getHostname());
                                List addresses = (List)entry.getValue();
                                String addressesString = "";
                                for (InetAddress address : addresses) {
                                    addressesString = addressesString + " " + address.getHostAddress();
                                }
                                FindServersPanel.this.resultTableModel.addEntry(addressesString);
                                FindServersPanel.this.resultTableModel.addEntry("" + srv.getPort());
                                FindServersPanel.this.resultTableModel.addEntry("" + srv.getPriority());
                                FindServersPanel.this.resultTableModel.addEntry("" + srv.getWeight());
                            }
                        }
                        FindServersPanel.this.lookupButton.setEnabled(true);
                    }
                });
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    class CanonicalHostNameOperation
    implements Operation {
        CanonicalHostNameOperation() {
        }

        @Override
        public void execute() throws Exception {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindServersPanel.this.lookupProgressBar.setIndeterminate(true);
                    FindServersPanel.this.workbench.startWorkIndicator();
                    FindServersPanel.this.workbench.setStatusbarMessage(FindServersPanel.this.messages.getMessage("connection.dns.canonicalhostname"));
                }
            });
            final String canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindServersPanel.this.lookupProgressBar.setIndeterminate(false);
                    FindServersPanel.this.workbench.stopWorkIndicator();
                    FindServersPanel.this.workbench.setStatusbarMessage(canonicalHostName);
                    if (FindServersPanel.this.domainNameField.getText() != null && FindServersPanel.this.domainNameField.getText().length() < 1) {
                        FindServersPanel.this.domainNameField.setText(canonicalHostName);
                    }
                }
            });
        }
    }
}

