/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.connection;

import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import nu.zoom.ldap.eon.connection.ConnectionFactory;
import nu.zoom.ldap.eon.connection.ConnectionMenuChangeHandler;
import nu.zoom.ldap.eon.connection.dns.FindServersMenuItem;
import nu.zoom.ldap.eon.desktop.ComponentFactory;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.util.dns.Resolver;
import org.ops4j.gaderian.Messages;

public class ConnectionPlugIn
implements PlugIn,
WorkbenchListener {
    private JMenu connectionsMenu = null;
    private final Workbench workbench;
    private final Messages messages;
    private final List<ConnectionFactory> connectionFactories;
    private final OperationManager operationManager;
    private final ComponentFactory componentFactory;
    private final Resolver resolver;

    public ConnectionPlugIn(Workbench workbench, Messages messages, OperationManager operationManager, ComponentFactory componentFactory, List<ConnectionFactory> factories, Resolver resolver) {
        this.workbench = workbench;
        this.messages = messages;
        this.operationManager = operationManager;
        this.componentFactory = componentFactory;
        this.connectionFactories = factories;
        this.resolver = resolver;
    }

    public void initialize() throws Exception {
        this.workbench.addWorkBenchListener((WorkbenchListener)this);
    }

    public void start() {
        if (this.connectionsMenu == null) {
            this.connectionsMenu = new JMenu(this.messages.getMessage("connection.menu"));
            this.connectionsMenu.add((Action)((Object)new FindServersMenuItem(this.messages, this.workbench, this.operationManager, this.resolver)));
            if (this.connectionFactories.size() > 0) {
                for (ConnectionFactory factory : this.connectionFactories) {
                    ConnectionMenuChangeHandler menuHandler = new ConnectionMenuChangeHandler(this.workbench, this.messages, this.componentFactory, this.operationManager, factory);
                    this.connectionsMenu.add(menuHandler.getMenu());
                }
            }
        }
        this.workbench.getMenuBar().addMenu("connectionsmenu", this.connectionsMenu);
    }

    public void close() {
    }
}

