/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.ldap.eon.clipboard.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboard;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboardItem;
import nu.zoom.ldap.eon.clipboard.DirectoryClipboardListener;
import nu.zoom.ldap.eon.clipboard.impl.DirectoryObjectCopyClipboardItem;
import nu.zoom.ldap.eon.clipboard.impl.DirectoryObjectCutClipboardItem;
import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.common.BackendException;
import org.ops4j.gaderian.Messages;

public class DirectoryClipboardImpl
implements DirectoryClipboard {
    private ArrayList<DirectoryClipboardListener> listeners = new ArrayList();
    private LinkedList<DirectoryClipboardItem> clipboard = new LinkedList();
    private Messages messages;
    private Workbench workbench;
    private DirectoryEventListenerRegistry eventRegistry;

    public DirectoryClipboardImpl(Messages messages, Workbench workbench, DirectoryEventListenerRegistry eventRegistry) {
        this.messages = messages;
        this.workbench = workbench;
        this.eventRegistry = eventRegistry;
    }

    @Override
    public synchronized void addCopy(DirectoryTreeObject sourceObject) {
        this.clipboard.add(new DirectoryObjectCopyClipboardItem(sourceObject, this.messages, this.workbench, this.eventRegistry));
        this.fireClipboardChanged();
    }

    @Override
    public synchronized void addCut(DirectoryTreeObject sourceObject) {
        this.clipboard.add(new DirectoryObjectCutClipboardItem(sourceObject, this.messages, this.workbench, this.eventRegistry));
        this.fireClipboardChanged();
    }

    @Override
    public synchronized void removeClipboardItem(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID can not be null");
        }
        Iterator clipboardIterator = this.clipboard.iterator();
        boolean foundIt = false;
        while (!foundIt && clipboardIterator.hasNext()) {
            DirectoryClipboardItem item = (DirectoryClipboardItem)clipboardIterator.next();
            if (item == null || !id.equals(item.getID())) continue;
            foundIt = true;
            this.clipboard.remove(item);
            this.fireClipboardChanged();
        }
    }

    @Override
    public synchronized void triggerPasteAction(DirectoryTreeObject targetObject) throws BackendException {
        if (this.clipboard.size() > 0) {
            DirectoryClipboardItem item = this.clipboard.removeFirst();
            this.fireClipboardChanged();
            if (item instanceof DirectoryObjectCopyClipboardItem) {
                ((DirectoryObjectCopyClipboardItem)item).execute(targetObject);
            } else if (item instanceof DirectoryObjectCutClipboardItem) {
                ((DirectoryObjectCutClipboardItem)item).execute(targetObject);
            }
        }
    }

    @Override
    public synchronized void addDirectoyClipboardListener(DirectoryClipboardListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeDirectoyClipboardListener(DirectoryClipboardListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireClipboardChanged() {
        for (DirectoryClipboardListener listener : this.listeners) {
            listener.clipboardContentChanged();
        }
    }
}

