/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.util;

import java.net.URL;

import javax.swing.ImageIcon;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public class MessagesUtil
{

	private MessagesUtil() {
		super();
	}

	public static ImageIcon getIconFromMessages(
			Messages messages,
			String iconKey) {
		String resourceName = messages.getMessage(iconKey);
		URL url = MessagesUtil.class.getResource(resourceName);
		ImageIcon icon = null;
		if (url != null) {
			icon = new ImageIcon(url);
		}
		return icon;
	}
}
