/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.operation;

import nu.zoom.swing.desktop.Workbench;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.3 $
 * @author $Author: johan $
 */
public class OperationRunnerImpl implements OperationRunner
{

	private OperationManager manager;
	private Workbench workbench;
	private Messages messages;

	public OperationRunnerImpl(OperationManager manager, Workbench workbench,
			Messages messages) {
		super();
		this.manager = manager;
		this.workbench = workbench;
		this.messages = messages;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.operation.OperationRunner#run(java.lang.Runnable)
	 */
	public void run(Operation operation) {
		manager.operationStarting(this);
		try {
			operation.execute();
		} catch (Exception e) {
			manager.operationFinished(this);
			workbench.getErrorReporter().reportError(
					messages.getMessage("operation.error"),
					e);
		}
		manager.operationFinished(this);
	}
}
