/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.operation;

import java.util.ArrayList;

import nu.zoom.swing.desktop.Workbench;

/**
 * @version $Revision: 1.5 $
 * @author $Author: johan $
 */
public class OperationManagerImpl implements OperationManager
{

	private ThreadGroup operationRunnerThreadGroup = new ThreadGroup(
			"Operation manager");
	private ArrayList<OperationRunner> currentOperations = new ArrayList<OperationRunner>();
	private Workbench workbench;
	private OperationRunner operationRunner ;

	public OperationManagerImpl(Workbench workbench, OperationRunner operationRunner) {
		super();
		this.workbench = workbench;
		this.operationRunner = operationRunner ;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.operation.OperationManager#operationStarting(nu.zoom.ldap.eon.operation.OperationRunner)
	 */
	public synchronized void operationStarting(OperationRunner operation) {
		if (operation == null) {
			throw new IllegalArgumentException("Operation can not be null");
		}
		workbench.startWorkIndicator();
		currentOperations.add(operation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.operation.OperationManager#operationFinished(nu.zoom.ldap.eon.operation.OperationRunner)
	 */
	public synchronized void operationFinished(OperationRunner operation) {
		currentOperations.remove(operation);
		workbench.stopWorkIndicator();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.operation.OperationManager#runOperation(java.lang.Runnable)
	 */
	public void runOperation(final Operation operation) {
		Thread runThread = new Thread(
				operationRunnerThreadGroup,
				new Runnable() {

					public void run() {
						operationRunner.run(operation);
					}
				});
		runThread.setName("OperationRunner");
		runThread.start();
	}
}
