/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.operation;

/**
 * Runs operations in separate threads to help make the GUI more responsive.
 * 
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public interface OperationManager
{

	/**
	 * Schedule an operation for execution. The operation will be run in a
	 * separate thread.
	 * 
	 * @param operation
	 *            The operation to run. Can not be null.
	 */
	public void runOperation(Operation operation);

	/**
	 * Internal method used by operations to inform the manager of its state.
	 * There is no need to call this method.
	 * 
	 * @param operation
	 *            The operation that is starting.
	 */
	public void operationStarting(OperationRunner operation);

	/**
	 * Internal method used by operations to inform the manager of its state.
	 * There is no need to call this method.
	 * 
	 * @param operation
	 *            The operation that is starting.
	 */
	public void operationFinished(OperationRunner operation);
}
