/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.event;

import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.Icon;

/**
 * Interface that helps in construction of Actions that are to appear on menus
 * and toolbars.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
public interface ActionValues
{

	/**
	 * Get the name of the action. This will be displayed on menues and
	 * toolbars.
	 * 
	 * @return The name. Must not be null.
	 */
	public String getName();

	/**
	 * Get the tooltip text to use for this action.
	 * 
	 * @return The tooltip text. Null is valid and means to not set a tooltip
	 *         text.
	 */
	public String getToolTip();

	/**
	 * Get the Icon to use on the action.
	 * 
	 * @return The icon to use, null indicates that this action should not have
	 *         an Icon.
	 */
	public Icon getIcon();

	/**
	 * Get the mnemonic key to use for the action. A mnemonic is a key that
	 * makes an already visible menu item be chosen. See <a
	 * href="http://java.sun.com/docs/books/tutorial/uiswing/components/menu.html">
	 * How to use menues </a>
	 * 
	 * @see javax.swing.Action#MNEMONIC_KEY
	 * @see java.awt.event.KeyEvent
	 * @return A key event for the mnemonic key. Return null if this item does
	 *         not have a mnemonic key.
	 */
	public Integer getMnemonic();

	/**
	 * Set the accelerator key. An accelerator is a key combination that causes
	 * a menu item to be chosen, whether or not it's visible. See <a
	 * href="http://java.sun.com/docs/books/tutorial/uiswing/components/menu.html">
	 * How to use menues </a>
	 * 
	 * @see KeyEvent
	 * @see Action#ACCELERATOR_KEY
	 * @return The key used to trigger the action. For example KeyEvent.VK_L.
	 *         Null means that no accelerator key is used.
	 */
	public Integer getAcceleratorKey();

	/**
	 * Set the accelerator key. An accelerator is a key combination that causes
	 * a menu item to be chosen, whether or not it's visible. See <a
	 * href="http://java.sun.com/docs/books/tutorial/uiswing/components/menu.html">
	 * How to use menues </a>
	 * 
	 * @see KeyEvent
	 * @see Action#ACCELERATOR_KEY
	 * @return The key mask used in combination with the accelrator key (for
	 *         example KeyEvent.CTRL_DOWN_MASK)). Null means that no mask is
	 *         used.
	 */
	public Integer getAcceleratorKeyMask();
}
