/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.event;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

import nu.zoom.util.UniqueIDGenerator;

/**
 * @author $Author: johan $
 * @version $Revision: 1.2 $
 */
public class ActionUtils
{

	private static UniqueIDGenerator idGenerator = new UniqueIDGenerator();

	private ActionUtils() {
		super();
	}

	/**
	 * Set the action values (icon, tooltip et c.).
	 * 
	 * @see ActionUtils#setActionValues(Action, ActionValues, JComponent)
	 * 
	 * @param action
	 *            The action to decorate. Must not be null.
	 * @param values
	 *            The values to use. Must not be null.
	 */
	public static void setActionValues(Action action, ActionValues values) {
		setActionValues(action, values, null);
	}

	/**
	 * Set the action values (icon, tooltip etc) and bind accelerator key to the
	 * WHEN_FOCUSED input map.
	 * 
	 * @param action
	 *            The action to decorate. Must not be null.
	 * @param values
	 *            The values to use. Must not be null.
	 * @param component
	 *            The component that we are to bind the accelrator keys to. Can
	 *            be null to not bind the accelerator keys to the input map.
	 */
	public static void setActionValues(
			Action action,
			ActionValues values,
			JComponent component) {
		if (action == null) {
			throw new IllegalArgumentException("Action can not be null");
		}
		if (values == null) {
			throw new IllegalArgumentException("Values must not be null");
		}

		if (values.getName() == null) {
			throw new IllegalArgumentException("Name must not be null");
		}

		action.putValue(Action.NAME, values.getName());

		if (values.getAcceleratorKey() != null) {
			int accelKey = values.getAcceleratorKey().intValue();
			int mask = (values.getAcceleratorKeyMask() != null) ? values
					.getAcceleratorKeyMask().intValue() : 0;
			KeyStroke stroke = KeyStroke.getKeyStroke(accelKey, mask);
			action.putValue(Action.ACCELERATOR_KEY, stroke);
			if (component != null) {
				String actionName = idGenerator.getID();
				component.getActionMap().put(actionName, action);
				component.getInputMap(JComponent.WHEN_FOCUSED).put(
						stroke,
						actionName);
			}
		}
		if (values.getMnemonic() != null) {
			action.putValue(Action.MNEMONIC_KEY, values.getMnemonic());
		}

		if (values.getToolTip() != null) {
			action.putValue(Action.SHORT_DESCRIPTION, values.getToolTip());
		}

		if (values.getIcon() != null) {
			action.putValue(Action.SMALL_ICON, values.getIcon());
		}

	}
}
