/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.event.KeyEvent;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.swing.Icon;
import javax.swing.JOptionPane;

import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.swing.desktop.Workbench;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.3 $
 * @author $Author: johan $
 */
public class RenameItem implements DirectoryTreePopUpItem
{

	private Messages messages;
	private Workbench workbench;
	private DirectoryEventListenerRegistry eventRegistry;

	public RenameItem(Messages messages, Workbench workbench,
			DirectoryEventListenerRegistry eventRegistry) {
		super();
		this.messages = messages;
		this.workbench = workbench;
		this.eventRegistry = eventRegistry;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem#activate(nu.zoom.ldap.eon.directory.tree.DirectoryTree)
	 */
	public void activate(DirectoryTree tree) {

		DirectoryTreeObject[] selectedNodes = null;
		try {
			selectedNodes = tree.getSelectedNodes();
		} catch (NamingException e) {
			selectedNodes = null;
		}
		if ((selectedNodes != null) && (selectedNodes.length > 0)) {
			DirectoryTreeObject nodeToRename = selectedNodes[0];
			final Name sourceName = nodeToRename.getDistinguishedName();
			Name sourceRDN = sourceName.getSuffix(sourceName.size() - 1);
			String oldName = sourceRDN.toString();
			int typeBreak = oldName.indexOf('=');
			if (typeBreak > 0) {
				String newName = JOptionPane.showInputDialog(workbench
						.getDialogOwner(), messages.format(
						"tree.popup.rename.message",
						oldName), oldName.substring(typeBreak + 1, oldName
						.length()));
				if ((newName != null) && (newName.trim().length() > 0)) {
					if (newName.indexOf('/') != -1) {
						newName = newName.replaceAll("/", "\\/") ;
					}
					String namingAttributeID = oldName.substring(0, typeBreak);
					String newRDN = namingAttributeID + "=" + newName;
					Name targetName = sourceName
							.getPrefix(sourceName.size() - 1);
					try {
						targetName.add(newRDN);
						tree.getConnection().rename(sourceName, targetName);
						Name parentName = targetName.getPrefix(targetName
								.size() - 1);
						eventRegistry.fireStructureChanged(
								tree.getConnectionInformation().getGUID(),
								parentName);
					} catch (InvalidNameException e1) {
						workbench.getErrorReporter().reportError(
								messages.format(
										"tree.popup.rename.parseerror",
										newRDN),
								e1);
					} catch (NamingException e) {
						workbench.getErrorReporter().reportError(
								messages.format(
										"tree.popup.rename.fail",
										sourceName.toString(),
										targetName.toString()),
								e);
					}
				}
			} else {
				workbench.getErrorReporter()
						.reportError(
								messages.format(
										"tree.popup.rename.parseerror",
										oldName));
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getName()
	 */
	public String getName() {
		return messages.getMessage("tree.popup.rename");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getToolTip()
	 */
	public String getToolTip() {
		return messages.getMessage("tree.popup.rename.tooltip");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getIcon()
	 */
	public Icon getIcon() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getMnemonic()
	 */
	public Integer getMnemonic() {
		return new Integer(KeyEvent.VK_F2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKey()
	 */
	public Integer getAcceleratorKey() {
		return new Integer(KeyEvent.VK_F2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKeyMask()
	 */
	public Integer getAcceleratorKeyMask() {
		return null;
	}

}
