/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.event.KeyEvent;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.swing.Icon;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public class RefreshItem implements DirectoryTreePopUpItem
{

	private Messages messages;

	/**
	 *  
	 */
	public RefreshItem(Messages messages) {
		super();
		this.messages = messages;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem#activate(nu.zoom.ldap.eon.directory.tree.DirectoryTree)
	 */
	public void activate(DirectoryTree tree) {
		DirectoryTreeObject[] selectedNodes = null;
		try {
			selectedNodes = tree.getSelectedNodes();
		} catch (NamingException e) {
			selectedNodes = null;
		}
		if (selectedNodes != null) {
			for (int i = 0; i < selectedNodes.length; i++) {
				Name node = selectedNodes[i].getDistinguishedName();
				tree.refresh(node);
				tree.showDN(node);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getName()
	 */
	public String getName() {
		return messages.getMessage("tree.popup.refresh");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getToolTip()
	 */
	public String getToolTip() {
		return messages.getMessage("tree.popup.refresh.tooltip");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getIcon()
	 */
	public Icon getIcon() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getMnemonic()
	 */
	public Integer getMnemonic() {
		return new Integer(KeyEvent.VK_F5);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKey()
	 */
	public Integer getAcceleratorKey() {
		return new Integer(KeyEvent.VK_F5);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKeyMask()
	 */
	public Integer getAcceleratorKeyMask() {
		return null;
	}
}
