/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.event.KeyEvent;

import javax.swing.Icon;

import nu.zoom.ldap.eon.clipboard.DirectoryClipboard;
import nu.zoom.swing.desktop.Workbench;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.3 $
 * @author $Author: johan $
 */
public class PasteItem implements DirectoryTreePopUpItem
{

	private Workbench workbench;
	private Messages messages;
	private DirectoryClipboard clipboard;

	public PasteItem(Messages messages, DirectoryClipboard clipboard,
			Workbench workbench) {
		super();
		this.clipboard = clipboard;
		this.messages = messages;
		this.workbench = workbench;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem#activate(nu.zoom.ldap.eon.directory.tree.DirectoryTree)
	 */
	public void activate(DirectoryTree tree)
	{
		try {
			DirectoryTreeObject selectedName = tree.getSelectedNode();
			if (selectedName != null) {
				clipboard.triggerPasteAction(selectedName);
			}
		} catch (Exception e) {
			workbench.getErrorReporter().reportError(e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getName()
	 */
	public String getName()
	{
		return messages.getMessage("tree.popup.paste");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getToolTip()
	 */
	public String getToolTip()
	{
		return messages.getMessage("tree.popup.copy.tooltip");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getIcon()
	 */
	public Icon getIcon()
	{
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getMnemonic()
	 */
	public Integer getMnemonic()
	{
		return new Integer(KeyEvent.VK_P);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKey()
	 */
	public Integer getAcceleratorKey()
	{
		return new Integer(KeyEvent.VK_V);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKeyMask()
	 */
	public Integer getAcceleratorKeyMask()
	{
		return new Integer(KeyEvent.CTRL_DOWN_MASK);
	}

}
