/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.ldap.InitialLdapContext;

/**
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public interface DirectoryTreeSelectionListener
{

	/**
	 * Notifies of a tree selection change.
	 * 
	 * @param tree
	 *            The tree that the user operated on.
	 * @param iCtx
	 *            The context the tree uses.
	 */
	public void selectionChanged(DirectoryTree tree, InitialLdapContext iCtx);
}
