/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import nu.zoom.ldap.eon.event.ActionValues;

/**
 * Plug in that appears on the directory tree pop up menu.
 * 
 * @version $Revision: 1.3 $
 * @author $Author: johan $
 */
public interface DirectoryTreePopUpItem extends ActionValues
{
	/**
	 * Called by the DirectoryTree when the user activates the menu item.
	 * 
	 * @param tree
	 *            The tree from which the user activated the item.
	 */
	public void activate(DirectoryTree tree);
}
