/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.Name;
import javax.naming.ldap.InitialLdapContext;

import nu.zoom.ldap.eon.connection.ConnectionInformation;

/**
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
class DirectoryTreeObjectImpl implements DirectoryTreeObject
{
	private Name dn;
	private DirectoryTree tree;

	DirectoryTreeObjectImpl(Name dn, DirectoryTree tree) {
		this.dn = dn;
		this.tree = tree;
	} /*
	   * (non-Javadoc)
	   * 
	   * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject#getConnection()
	   */

	public InitialLdapContext getConnection()
	{
		return tree.getConnection();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject#getConnectionInformation()
	 */
	public ConnectionInformation getConnectionInformation()
	{
		return tree.getConnectionInformation();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject#getDistinguishedName()
	 */
	public Name getDistinguishedName()
	{
		return dn;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreeObject#getTree()
	 */
	public DirectoryTree getTree()
	{
		return tree;
	}
}
