/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import javax.naming.Name;
import javax.naming.ldap.InitialLdapContext;

import nu.zoom.ldap.eon.connection.ConnectionInformation;

/**
 * An object in the tree component. This object represents the view of a
 * directory. This means that if you have two tree components that show the same
 * underlying directory, instances of this class will not be the same even if
 * they represent the same Context in the directory.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
public interface DirectoryTreeObject
{
	/**
	 * Get the tree component which this object belongs to.
	 * 
	 * @return The tree that this object belongs to.
	 */
	public DirectoryTree getTree();

	/**
	 * Get the connection this object uses.
	 * 
	 * @return The connection used to create this object.
	 */
	public InitialLdapContext getConnection();

	/**
	 * Get information about the connection this object uses.
	 * 
	 * @return Information about the connection.
	 */
	public ConnectionInformation getConnectionInformation();

	/**
	 * Get the directory name of this object.
	 * 
	 * @return The distinguished name for this object.
	 */
	public Name getDistinguishedName();
}
