/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.BorderLayout;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

import nu.zoom.ldap.eon.connection.ConnectionGUID;
import nu.zoom.ldap.eon.directory.attributes.AllAttributesComponent;
import nu.zoom.ldap.eon.operation.Operation;
import nu.zoom.ldap.eon.operation.OperationManager;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.preferences.Preferences;

import org.ops4j.gaderian.Messages;

public class DirectoryTreeAndAttributesComponent extends JComponent implements
        DirectoryTreeSelectionListener, WorkbenchFrameListener {

    private DirectoryTree treeComponent;
    private AllAttributesComponent attributesComponent;
    private OperationManager operationManager;
    private Workbench workbench;
    private Messages messages;
    private JSplitPane splitter;
    private Preferences preferences;
    private ConnectionGUID guid;

    public DirectoryTreeAndAttributesComponent(DirectoryTree treeComponent,
            AllAttributesComponent attributesComponent,
            OperationManager operationManager, Workbench workbench,
            Messages messages, Preferences preferences, ConnectionGUID guid) {
        super();
        this.treeComponent = treeComponent;
        this.attributesComponent = attributesComponent;
        this.operationManager = operationManager;
        this.workbench = workbench;
        this.messages = messages;
        this.preferences = preferences;
        this.guid = guid;
        buildGUI();
    }

    private void buildGUI() {
        setLayout(new BorderLayout());
        splitter = new JSplitPane(
                JSplitPane.HORIZONTAL_SPLIT,
                treeComponent,
                attributesComponent);
        add(splitter, BorderLayout.CENTER);
        treeComponent.addDirectoryTreeSelectionListener(this);
    }

    @Override
    public void selectionChanged(
            final DirectoryTree tree,
            final InitialLdapContext iCtx) {
        try {
            final DirectoryTreeObject node = tree.getSelectedNode();
            if (node != null) {
                operationManager.runOperation(new Operation() {

                    @Override
                    public void execute() throws NamingException {
                        Attributes attributes = iCtx.getAttributes(node.getDistinguishedName());
                        attributesComponent.show(
                                node.getDistinguishedName(),
                                attributes);
                    }
                });
            }
        } catch (NamingException e) {
            workbench.getErrorReporter().reportError(
                    messages.getMessage("error.treeComponent.getselectednode"),
                    e);
        }
    }

    public void setDividerLocation() {
        if (splitter != null) {
            try {
                Integer location = preferences.getInteger("DirectoryTreeAndAttributesComponent."
                        + guid.toString());
                if (location != null) {
                    splitter.setDividerLocation(location.intValue());
                } else {
                    splitter.setDividerLocation(0.5);
                }
            } catch (Exception e) {
                splitter.setDividerLocation(0.5);
            }
        }
    }

    @Override
    public void frameWillDispose(WorkbenchFrame frame) {
        Integer location = new Integer(splitter.getDividerLocation());
        try {
            preferences.setInteger("DirectoryTreeAndAttributesComponent."
                    + guid.toString(), location);
        } catch (BackendException e) {
        }
    }

    @Override
    public void frameClosed(WorkbenchFrame frame) {
    }

    @Override
    public void frameDetached(WorkbenchFrame frame) {
    }

    @Override
    public void frameAttached(WorkbenchFrame frame) {
    }
}
