/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.ldap.eon.directory.tree;

import java.awt.event.KeyEvent;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Icon;

import nu.zoom.ldap.eon.directory.event.DirectoryEventListenerRegistry;
import nu.zoom.swing.desktop.Workbench;

import org.ops4j.gaderian.Messages;

/**
 * @version $Revision: 1.5 $
 * @author $Author: johan $
 */
public class DeleteItem implements DirectoryTreePopUpItem
{

	private Messages messages;
	private Workbench workbench;
	private DirectoryEventListenerRegistry eventRegistry;

	public DeleteItem(Messages messages, Workbench workbench,
			DirectoryEventListenerRegistry eventRegistry) {
		super();
		this.messages = messages;
		this.workbench = workbench;
		this.eventRegistry = eventRegistry;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.directory.tree.DirectoryTreePopUpItem#activate(nu.zoom.ldap.eon.directory.tree.DirectoryTree)
	 */
	public void activate(DirectoryTree tree) {
		DirectoryTreeObject[] selectedNodes = null;
		try {
			selectedNodes = tree.getSelectedNodes();
		} catch (NamingException e) {
			selectedNodes = null;
		}
		if (selectedNodes != null) {
			for (int i = 0; i < selectedNodes.length; i++) {
				InitialLdapContext iCtx = tree.getConnection();
				Name nodeToDelete = selectedNodes[i].getDistinguishedName();
				Name parent = nodeToDelete.getPrefix(nodeToDelete.size() - 1);
				try {
					workbench.setStatusbarMessage(messages.format(
							"tree.popup.delete.node",
							nodeToDelete.toString()));
					iCtx.destroySubcontext(nodeToDelete);
					eventRegistry.fireStructureChanged(tree.getConnectionInformation().getGUID(), parent) ;
				} catch (NamingException e1) {
					workbench.getErrorReporter().reportError(
							messages.getMessage("error.tree.delete"),
							e1);
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getName()
	 */
	public String getName() {
		return messages.getMessage("tree.popup.delete");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getToolTip()
	 */
	public String getToolTip() {
		return messages.getMessage("tree.popup.delete.tooltip");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getIcon()
	 */
	public Icon getIcon() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getMnemonic()
	 */
	public Integer getMnemonic() {
		return new Integer(KeyEvent.VK_DELETE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKey()
	 */
	public Integer getAcceleratorKey() {
		return new Integer(KeyEvent.VK_DELETE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.ldap.eon.event.ActionValues#getAcceleratorKeyMask()
	 */
	public Integer getAcceleratorKeyMask() {
		return null;
	}

}
